/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.controller.ManagedResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class FailureResponse
implements ManagedResponse {
    private final String operationName;
    private final ManagedResponse.Outcome outcome;
    private final ContentType contentType;

    public FailureResponse(final String failure, String operationName, ContentType contentType) {
        this.operationName = operationName;
        this.outcome = new ManagedResponse.Outcome(){

            public boolean isSuccess() {
                return false;
            }

            public String getFailureDescription() {
                return failure;
            }
        };
        this.contentType = contentType;
    }

    public ManagedResponse.Outcome getOutcome() {
        return this.outcome;
    }

    public Object getResult() {
        return null;
    }

    public void writeResult(OutputStream outputStream, boolean pretty) throws IOException {
        switch (this.contentType) {
            case JSON: {
                this.writeJson(outputStream, pretty);
                break;
            }
            case XML: {
                this.writeXml(outputStream, pretty);
                break;
            }
            default: {
                throw new IOException(this.contentType + " is not a supported content type for a failure.");
            }
        }
    }

    private void writeJson(OutputStream out, boolean pretty) throws IOException {
        try {
            JSONObject json = new JSONObject();
            json.put("operationName", (Object)this.operationName);
            json.put("failure", (Object)this.outcome.getFailureDescription());
            String text = pretty ? json.toString(3) : json.toString();
            out.write(text.getBytes());
            out.write(10);
        }
        catch (JSONException e) {
            throw new IOException("Exception writing failure response to json. The failure response message was '" + this.outcome.getFailureDescription() + "'", e);
        }
    }

    private void writeXml(OutputStream out, boolean pretty) throws IOException {
        XMLStreamWriter writer;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not create XML streaming writer.", e);
        }
        try {
            writer.writeStartDocument("UTF-8", "1.0");
            FailureResponse.nl(writer, pretty);
            writer.writeStartElement("failureResult");
            FailureResponse.nl(writer, pretty);
            FailureResponse.indent(writer, 1, pretty);
            writer.writeStartElement("failure");
            writer.writeCharacters(this.outcome.getFailureDescription());
            writer.writeEndElement();
            FailureResponse.nl(writer, pretty);
            FailureResponse.indent(writer, 1, pretty);
            writer.writeStartElement("operationName");
            writer.writeCharacters(this.operationName);
            writer.writeEndElement();
            FailureResponse.nl(writer, pretty);
            writer.writeEndElement();
            writer.writeCharacters("\n");
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Exception writing failure response to XML. Failure response message was '" + this.outcome.getFailureDescription() + "'", e);
        }
    }

    private static void nl(XMLStreamWriter writer, boolean pretty) throws XMLStreamException {
        if (pretty) {
            writer.writeCharacters("\n");
        }
    }

    private static void indent(XMLStreamWriter writer, int depth, boolean pretty) throws XMLStreamException {
        if (pretty) {
            for (int i = 0; i < depth; ++i) {
                writer.writeCharacters("   ");
            }
        }
    }
}

