/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v22Handler;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v24Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v24Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV24TagIterator tags = new RawV24TagIterator(frame);
        while (tags.hasNext()) {
            ID3v2Frame.RawTag tag = tags.next();
            if (tag.name.equals("TIT2")) {
                this.title = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TPE1")) {
                this.artist = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TALB")) {
                this.album = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TYER")) {
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TDRC")) {
                if (this.year != null) continue;
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TCOM")) {
                this.composer = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("COMM")) {
                this.comments.add(this.getComment(tag.data, 0, tag.data.length));
                continue;
            }
            if (tag.name.equals("TRCK")) {
                this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (!tag.name.equals("TCON")) continue;
            this.genre = ID3v22Handler.extractGenre(this.getTagString(tag.data, 0, tag.data.length));
        }
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    private ID3Tags.ID3Comment getComment(byte[] data, int offset, int length) {
        return ID3v2Frame.getComment(data, offset, length);
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    private class RawV24TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV24TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            iD3v2Frame.getClass();
            super(iD3v2Frame, 4, 4, 1, 2);
        }
    }
}

