/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.json.JSONObject;

public class Utils {
    public static final String ACTIVITY_STREAM_TAB_SELECTED_COOKIED = "exo_social_activity_stream_tab_selected_%s";
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s_%s";
    public static final String LAST_UPDATED_ACTIVITIES_NUM = "exo_social_last_updated_activities_num_on_%s_of_%s";
    public static final String FROM = "from";
    public static final String OLD_FROM = "old_from";
    public static final String TO = "to";
    private static final String HOME = "home";
    public static final String NOT_SEEN_ACTIVITIES_COOKIES = "exo_social_not_seen_activities_%s";
    public static final String SEEN_ACTIVITIES_COOKIES = "exo_social_seen_activities_%s";
    private static Log LOG = ExoLogger.getLogger(Utils.class);

    public static String getOwnerRemoteId() {
        Identity identity;
        String currentUserName = URLUtils.getCurrentUser();
        if (currentUserName != null && currentUserName.length() > 0 && (identity = Utils.getIdentityManager().getOrCreateIdentity("organization", currentUserName, false)).isDeleted()) {
            currentUserName = null;
        }
        if (currentUserName == null || currentUserName.equals("")) {
            return Utils.getViewerRemoteId();
        }
        return currentUserName;
    }

    public static String getViewerRemoteId() {
        return RequestContext.getCurrentInstance().getRemoteUser();
    }

    public static boolean isOwner() {
        return Utils.getViewerRemoteId().equals(Utils.getOwnerRemoteId());
    }

    public static Identity getOwnerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), loadProfile);
    }

    public static Identity getViewerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), loadProfile);
    }

    public static Identity getOwnerIdentity() {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), false);
    }

    public static String getOwnerIdentityId() {
        Identity identity = Utils.getOwnerIdentity();
        return identity == null ? null : identity.getId();
    }

    public static Identity getViewerIdentity() {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), false);
    }

    public static TimeZone getViewerTimezone() {
        Identity userIdentity = Utils.getUserIdentity(Utils.getViewerRemoteId(), false);
        if (userIdentity == null || userIdentity.getProfile().getTimeZone() == null) {
            return TimeZone.getDefault();
        }
        String timeZoneId = userIdentity.getProfile().getTimeZone();
        return TimeZone.getTimeZone(timeZoneId);
    }

    public static int getViewerTimezoneDSTSavings() {
        Identity userIdentity = Utils.getUserIdentity(Utils.getViewerRemoteId(), false);
        if (userIdentity == null || userIdentity.getProfile().getTimeZoneDSTSavings() == null) {
            return TimeZone.getDefault().getDSTSavings();
        }
        return userIdentity.getProfile().getTimeZoneDSTSavings();
    }

    public static String getViewerIdentityId() {
        Identity identity = Utils.getViewerIdentity();
        return identity == null ? null : identity.getId();
    }

    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Utils.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static boolean isEnableUser(String userName) {
        return Utils.getUserIdentity(userName, false).isEnable();
    }

    public static List<String> getEnableUsers(String[] users) {
        if (users == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String user : users) {
            if (!Utils.isEnableUser(user)) continue;
            results.add(user);
        }
        return results;
    }

    public static Identity getSpaceIdentity(String spaceName, boolean loadProfile) {
        return Utils.getIdentityManager().getOrCreateIdentity("space", spaceName, loadProfile);
    }

    public static Identity getOwnerSpaceIdentity() {
        return Utils.getIdentityManager().getOrCreateIdentity("space", Utils.getOwnerRemoteId(), true);
    }

    public static List<Identity> getOwnerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getOwnerIdentity());
    }

    public static List<Identity> getViewerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getViewerIdentity());
    }

    public static void updateWorkingWorkSpace() {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.ignoreAJAXUpdateOnPortlets(true);
    }

    public static final ActivityManager getActivityManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final Relationship getRelationship(Identity identity) throws Exception {
        if (identity.equals((Object)Utils.getViewerIdentity())) {
            return null;
        }
        return Utils.getRelationshipManager().get(identity, Utils.getViewerIdentity());
    }

    public static final SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public static final ExoRouter getExoRouter() {
        return (ExoRouter)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoRouter.class);
    }

    public static String getCommentID() {
        return Utils.getValueFromRequestParam("commentId");
    }

    public static String getActivityID() {
        String uriActivity = Utils.getSelectedNode();
        if (uriActivity != null) {
            if ("activity".equals(uriActivity)) {
                return Utils.getValueFromRequestParam("id");
            }
            if (uriActivity.indexOf("view_full_activity") >= 0 || uriActivity.indexOf("reply_activity") >= 0) {
                return uriActivity.split("/")[3];
            }
        }
        return null;
    }

    public static boolean isFocusCommentBox() {
        return "1".equals(Utils.getValueFromRequestParam("comment"));
    }

    public static boolean isFocusCommentReplyBox() {
        return "2".equals(Utils.getValueFromRequestParam("comment"));
    }

    public static boolean isExpandLikers() {
        return "1".equals(Utils.getValueFromRequestParam("likes"));
    }

    public static String getValueFromRequestParam(String param) {
        PortalRequestContext request = Util.getPortalRequestContext();
        return request.getRequestParameter(param);
    }

    public static String getHeader(String param) {
        PortalRequestContext request = Util.getPortalRequestContext();
        return request.getRequest().getHeader(param);
    }

    public static String getValueFromRefererURI(String param) {
        int index;
        String refererURI = Utils.getHeader("referer");
        String value = null;
        if (refererURI != null && (index = refererURI.indexOf("?")) != -1) {
            String query = refererURI.substring(index + 1);
            Hashtable map = HttpUtils.parseQueryString((String)query);
            value = map.containsKey(param) ? ((String[])map.get(param))[0] : null;
            return value;
        }
        return value;
    }

    public static void displayFeedbackMessageInline(String parentId) {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            PortletRequestContext pContext = (PortletRequestContext)context;
            JavascriptManager jm = pContext.getJavascriptManager();
            String feedbackMessageType = Utils.getValueFromRequestParam("feedbackMessage");
            if (feedbackMessageType != null) {
                String message = res.getString("Notification.feedback.message." + feedbackMessageType);
                String userName = Utils.getValueFromRequestParam("userName");
                String spaceId = Utils.getValueFromRequestParam("spaceId");
                if (userName != null) {
                    message = message.replace("{0}", Utils.getUserIdentity(userName, false).getProfile().getFullName());
                }
                if (spaceId != null) {
                    message = message.replace("{1}", Utils.getSpaceService().getSpaceById(spaceId).getDisplayName());
                }
                message = message.replace("'", "${simpleQuote}");
                jm.require("SHARED/socialUtil", "socialUtil").addScripts("socialUtil.feedbackMessageInline('" + parentId + "','" + message + "');");
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to init the feedback message");
        }
    }

    public static String getURI(String url) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), url);
        return nodeURL.setResource(resource).toString();
    }

    public static String getSelectedNode() {
        PortalRequestContext request = Util.getPortalRequestContext();
        return request.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
    }

    public static String getSpaceURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    public static String getSpaceHomeURL(Space space) {
        String groupId = space.getGroupId();
        String permanentSpaceName = groupId.split("/")[2];
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = null;
        resource = permanentSpaceName.equals(space.getPrettyName()) ? new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, permanentSpaceName) : new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }

    public static void setCookies(String key, String value) {
        Utils.removeCookie(key);
        PortalRequestContext request = Util.getPortalRequestContext();
        Cookie cookie = new Cookie(key, value);
        cookie.setPath(request.getRequest().getContextPath());
        cookie.setMaxAge(Integer.MAX_VALUE);
        request.getResponse().addCookie(cookie);
    }

    private static Cookie[] removeCookie(String key) {
        PortalRequestContext request = Util.getPortalRequestContext();
        Object[] cookies = request.getRequest().getCookies();
        if (cookies != null) {
            int found = -1;
            for (int i = 0; i < cookies.length; ++i) {
                if (!key.equals(cookies[i].getName())) continue;
                found = i;
                break;
            }
            if (found > -1) {
                ArrayUtils.remove((Object[])cookies, (int)found);
            }
        }
        return cookies;
    }

    public static String getCookies(String key) {
        PortalRequestContext request = Util.getPortalRequestContext();
        Cookie[] cookies = request.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static boolean hasCookies(String key) {
        return Utils.getCookies(key) != null;
    }

    public static long getLastVisited(String key, String mode) {
        long currentVisited = Calendar.getInstance().getTimeInMillis();
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        String strValue = Utils.getCookies(cookieKey);
        if (strValue == null) {
            return currentVisited;
        }
        return Long.parseLong(strValue);
    }

    private static String getCookieValue(String key, String mode) {
        long currentVisited = Calendar.getInstance().getTimeInMillis();
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        String strValue = Utils.getCookies(cookieKey);
        if (strValue == null) {
            return "" + currentVisited;
        }
        return strValue;
    }

    public static void setLastVisited(String mode) {
        String gotTo = Utils.getCookieValue(TO, mode);
        String gotFrom = Utils.getCookieValue(FROM, mode);
        Utils.setCookie(OLD_FROM, mode, gotFrom);
        Utils.setCookie(FROM, mode, gotTo);
        long nextTo = Calendar.getInstance().getTimeInMillis();
        Utils.setCookie(TO, mode, "" + nextTo);
    }

    private static void setCookie(String key, String mode, String value) {
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        Utils.setCookies(cookieKey, value);
    }

    public static String listToString(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int lastIdx = 0;
        for (String s : list) {
            if (s == null || s.length() == 0) continue;
            sb.append(s);
            if (++lastIdx >= list.size()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isHomePage() {
        String selectedNode = Utils.getSelectedNode();
        return selectedNode == null || selectedNode.length() == 0 || HOME.equals(selectedNode);
    }

    public static final String centerTrunc(String str, int head, int tail) {
        StringBuffer buf = null;
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        return buf.toString();
    }

    public static final String trunc(String str, int head) {
        StringBuffer buf = null;
        if (str.length() <= head + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append(str.substring(0, head)).append("...");
        return buf.toString();
    }

    public static String normalizeString(String str) {
        if (str != null) {
            return str.trim().replaceAll("(\\s){2,}", " ");
        }
        return null;
    }

    public static boolean isSpaceContext() {
        return Utils.getSpaceByContext() != null;
    }

    public static String getSpaceUrlByContext() {
        Space space = Utils.getSpaceByContext();
        return space != null ? space.getUrl() : null;
    }

    public static void initUserProfilePopup(String uiActivityId) {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        jm.require("SHARED/social-ui-profile", "profile").addScripts("profile.initUserProfilePopup('" + uiActivityId + "', null);");
    }

    public static void clearUserProfilePopup() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        jm.require("SHARED/social-ui-profile", "profile").addScripts("profile.clearUserProfilePopup();");
    }

    public static Space getSpaceByContext() {
        String groupId;
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith("/spaces")) {
            return null;
        }
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null && StringUtils.isNotBlank((String)(groupId = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME))) && groupId.startsWith("/spaces")) {
            return spaceService.getSpaceByGroupId(groupId);
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        Space space = null;
        if (StringUtils.isNotBlank((String)spacePrettyName) && !spacePrettyName.startsWith(";jsessionid=") && (space = spaceService.getSpaceByPrettyName(spacePrettyName)) == null) {
            String groupId2 = String.format("%s/%s", "/spaces", spacePrettyName);
            space = spaceService.getSpaceByGroupId(groupId2);
        }
        return space;
    }

    public static void clearCacheOnUserPopup() {
        WebuiRequestContext reqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = reqContext.getJavascriptManager();
        jm.require("SHARED/jquery", "jq").addScripts("(function($) { $('#socialUsersData').data('CacheSearch', {}); })(jq);");
    }

    public static String appRes(String msgKey) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        try {
            return context.getApplicationResourceBundle().getString(msgKey);
        }
        catch (MissingResourceException ex) {
            if (PropertyManager.isDevelopping()) {
                LOG.warn((Object)("Can not find resource bundle for key : " + msgKey));
            }
            return null;
        }
    }

    public static String getResolvedAppLabel(UserNode userNode) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        if (userNode == null) {
            return null;
        }
        String id = userNode.getId();
        String nodeLabel = userNode.getLabel();
        if (nodeLabel != null) {
            UserNavigation navigation = userNode.getNavigation();
            ResourceBundle bundle = navigation.getBundle();
            return ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)nodeLabel);
        }
        if (id != null) {
            Locale userLocale = Util.getPortalRequestContext().getLocale();
            Locale portalLocale = SpaceUtils.getUserPortal().getLocale();
            DescriptionService descriptionService = userPortalConfigService.getDescriptionService();
            State description = descriptionService.resolveDescription(id, portalLocale, userLocale);
            if (description != null) {
                return description.getName();
            }
        }
        return null;
    }

    public static void initConfirmationPopup(String componentId) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        JSONObject object = new JSONObject();
        object.put("componentId", (Object)componentId);
        object.put("Caption", (Object)res.getString("Confirmation.label.Caption"));
        object.put("OK", (Object)res.getString("Confirmation.label.OK"));
        object.put("Cancel", (Object)res.getString("Confirmation.label.Cancel"));
        context.getJavascriptManager().getRequireJS().require("SHARED/socialUtil", "socialUtil").addScripts("socialUtil.applyConfirmPopup(" + object.toString() + ");");
    }

    public static boolean isUserBoundToSpace(String username, String spaceId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)container.getComponentInstanceOfType(GroupSpaceBindingService.class);
        return groupSpaceBindingService.countUserBindings(spaceId, username) > 0L;
    }

    public static boolean isExternal(Identity userIdentity) {
        return userIdentity.getProfile().getProperty("external") != null && userIdentity.getProfile().getProperty("external").equals("true");
    }
}

