/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONObject;

@Path(value="/perkstore/api/product")
@Api(value="/perkstore/api/product", description="Manages perk store products")
@RolesAllowed(value={"users"})
public class PerkStoreProductREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreProductREST.class);
    private PerkStoreService perkStoreService;

    public PerkStoreProductREST(PerkStoreService perkStoreService) {
        this.perkStoreService = perkStoreService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates or modifies a product", httpMethod="POST", response=Response.class, consumes="application/json", produces="application/json", notes="returns saved product")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveProduct(@ApiParam(value="Product object", required=true) Product product) {
        if (product == null) {
            LOG.warn((Object)"Bad request sent to server with empty product");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            product = this.perkStoreService.saveProduct(product, currentUserId);
            return Response.ok((Object)product).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Saving product", currentUserId, product);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving product", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{productId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves a product by its id", httpMethod="GET", response=Response.class, produces="application/json", notes="returns selected product if exists")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProduct(@ApiParam(value="Product technical id", required=true) @PathParam(value="productId") long productId) {
        if (productId == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty productId");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            Product product = this.perkStoreService.getProductById(productId, currentUserId);
            return Response.ok((Object)product).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting product", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get the list of product accessible by current user", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of products")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response listProducts(@ApiParam(value="Returning only the available products or all products", defaultValue="false") @QueryParam(value="available") boolean available, @ApiParam(value="Returning the number of Products or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        String currentUserId = Utils.getCurrentUserId();
        try {
            List<Product> allProducts = this.perkStoreService.getProducts(available, currentUserId);
            if (returnSize) {
                JSONObject size = new JSONObject();
                size.put("size", allProducts.size());
                return Response.ok((Object)size.toString()).build();
            }
            return Response.ok(allProducts).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Getting products list", currentUserId, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting products list", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="{productId}/image/{imageId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get product image by its id", httpMethod="GET", response=Response.class, notes="returns image content")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=304, message="Image not modified"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProductImage(@Context Request request, @ApiParam(value="Product technical id", required=true) @PathParam(value="productId") long productId, @ApiParam(value="Image file technical id", required=true) @PathParam(value="imageId") long imageId) {
        String currentUserId = Utils.getCurrentUserId();
        try {
            FileDetail fileDetail = this.perkStoreService.getFileDetail(productId, imageId, false, currentUserId);
            if (fileDetail == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            long lastUpdated = fileDetail.getLastUpdated();
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                fileDetail = this.perkStoreService.getFileDetail(productId, imageId, true, currentUserId);
                ByteArrayInputStream stream = new ByteArrayInputStream(fileDetail.getData());
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.cacheControl(cc);
            return builder.cacheControl(cc).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Getting products list", currentUserId, null);
        }
        catch (Exception e) {
            LOG.warn("Error getting image {} on product {}", new Object[]{imageId, productId, e});
            return Response.serverError().build();
        }
    }
}

