/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class Upgradability
extends Contract {
    public static final String BINARY = "";
    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_UPGRADEDATA = "upgradeData";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_GETDATAADDRESS = "getDataAddress";
    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected Upgradability(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Upgradability(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Upgradability(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Upgradability(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEIMPLEMENTATION, Arrays.asList(new Address(160, _proxy), new Uint16(_version), new Address(160, _newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> version() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> paused() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATA, Arrays.asList(new Uint16(_dataVersion), new Address(160, _dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> getDataAddress(BigInteger _version) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETDATAADDRESS, Arrays.asList(new Uint16(_version)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATAANDIMPLEMENTATION, Arrays.asList(new Address(160, _proxy), new Uint16(_version), new Address(160, _newImplementation), new Uint16(_dataVersion), new Address(160, _dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> implementationAddress() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String _newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, _newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedEventResponse>(){

            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Upgradability.this.extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedDataEventResponse>(){

            public UpgradedDataEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Upgradability.this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADEDDATA_EVENT));
        return this.upgradedDataEventFlowable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Upgradability.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static Upgradability load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Upgradability(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Upgradability load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Upgradability(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Upgradability load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Upgradability(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Upgradability load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Upgradability(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<Upgradability> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    public static RemoteCall<Upgradability> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<Upgradability> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<Upgradability> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static class TransferOwnershipEventResponse
    extends BaseEventResponse {
        public String newOwner;
    }

    public static class UpgradedDataEventResponse
    extends BaseEventResponse {
        public BigInteger dataVersion;
        public String dataAddress;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public BigInteger implementationVersion;
        public String implementationAddress;
    }
}

