/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.hash;

import java.util.Arrays;

public class SaltedHash {
    private final String algorithm;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] hash;

    public SaltedHash(String algorithm, int iterationCount, byte[] salt, byte[] hash) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm cannot be null.");
        }
        if (salt == null) {
            throw new NullPointerException("salt cannot be null.");
        }
        if (hash == null) {
            throw new NullPointerException("hash cannot be null.");
        }
        this.algorithm = algorithm;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.hash = hash;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.hash);
        result = 31 * result + this.iterationCount;
        result = 31 * result + Arrays.hashCode(this.salt);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaltedHash)) {
            return false;
        }
        SaltedHash other = (SaltedHash)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        if (this.iterationCount != other.iterationCount) {
            return false;
        }
        return Arrays.equals(this.salt, other.salt);
    }

    public String toString() {
        return "SaltedHash [algorithm=" + this.algorithm + ", iterationCount=" + this.iterationCount + ", salt=" + Arrays.toString(this.salt) + ", hash=" + Arrays.toString(this.hash) + "]";
    }
}

