/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.management;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedPropertyMetaData;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagedTypeMetaData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.management.RestResourceMethod;
import org.exoplatform.services.rest.ext.management.RestResourceProperty;
import org.exoplatform.services.rest.ext.management.ValueWrapper;
import org.exoplatform.services.rest.ext.management.invocation.MethodInvoker;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class RestResource {
    private static final Log LOG = ExoLogger.getLogger(RestResource.class);
    final Map<String, RestResourceProperty> properties;
    private final List<RestResourceMethod> methods;
    private final ManagedResource managedResource;
    private final String name;
    private final String description;

    public RestResource(String name, ManagedResource managedResource) {
        ManagedTypeMetaData managedType = managedResource.getMetaData();
        HashMap<String, RestResourceProperty> properties = new HashMap<String, RestResourceProperty>();
        for (ManagedPropertyMetaData managedProperty : managedType.getProperties()) {
            RestResourceProperty resourceProperty = new RestResourceProperty(managedProperty);
            properties.put(resourceProperty.getName(), resourceProperty);
        }
        ArrayList<RestResourceMethod> methods = new ArrayList<RestResourceMethod>();
        for (ManagedMethodMetaData managedMethod : managedType.getMethods()) {
            RestResourceMethod resourceMethod = new RestResourceMethod(managedMethod);
            methods.add(resourceMethod);
        }
        this.name = name;
        this.description = managedType.getDescription();
        this.managedResource = managedResource;
        this.properties = Collections.unmodifiableMap(properties);
        this.methods = methods;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<RestResourceProperty> getProperties() {
        return this.properties.values();
    }

    public Collection<RestResourceMethod> getMethods() {
        return this.methods;
    }

    @GET
    @Produces(value={"application/json"})
    public RestResource get() {
        return this;
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response get(@Context UriInfo info, @PathParam(value="name") String name) {
        MethodInvoker getter;
        MultivaluedMap parameters = info.getQueryParameters();
        RestResourceProperty property = this.properties.get(name);
        if (property != null && (getter = property.getGetterInvoker()) != null) {
            return this.safeInvoke(getter, (Map<String, List<String>>)parameters);
        }
        return this.tryInvoke(name, (MultivaluedMap<String, String>)parameters, ImpactType.READ);
    }

    @PUT
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response put(@Context UriInfo info, @PathParam(value="name") String name) {
        MethodInvoker setter;
        MultivaluedMap<String, String> parameters = this.getParameters(info);
        RestResourceProperty property = this.properties.get(name);
        if (property != null && (setter = property.getSetterInvoker()) != null) {
            return this.safeInvoke(setter, (Map<String, List<String>>)parameters);
        }
        return this.tryInvoke(name, parameters, ImpactType.IDEMPOTENT_WRITE);
    }

    @POST
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response post(@Context UriInfo info, @PathParam(value="name") String name) {
        return this.tryInvoke(name, this.getParameters(info), ImpactType.WRITE);
    }

    private Response tryInvoke(String methodName, MultivaluedMap<String, String> parameters, ImpactType impact) {
        RestResourceMethod method = this.lookupMethod(methodName, parameters.keySet(), impact);
        if (method != null) {
            MethodInvoker invoker = method.getMethodInvoker();
            return this.safeInvoke(invoker, (Map<String, List<String>>)parameters);
        }
        return null;
    }

    private RestResourceMethod lookupMethod(String methodName, Set<String> argNames, ImpactType impact) {
        for (RestResourceMethod method : this.methods) {
            if (!method.getName().equals(methodName) || method.metaData.getImpact() != impact || !method.parameterNames.equals(argNames)) continue;
            return method;
        }
        return null;
    }

    private Response safeInvoke(MethodInvoker invoker, Map<String, List<String>> argMap) {
        Object resource = this.managedResource.getResource();
        this.managedResource.beforeInvoke(resource);
        try {
            Object ret = invoker.invoke(resource, argMap);
            Response.ResponseBuilder rb = ret == null ? Response.ok() : Response.ok(ValueWrapper.wrap(ret));
            Response response = rb.build();
            return response;
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("An exception occurred: " + e.getMessage()));
            throw new WebApplicationException(Response.serverError().entity((Object)e.getMessage()).build());
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("An exception occurred: " + e.getMessage()));
            throw new WebApplicationException(Response.serverError().entity((Object)e.getMessage()).build());
        }
        finally {
            this.managedResource.afterInvoke(resource);
        }
    }

    private MultivaluedMap<String, String> getParameters(UriInfo info) {
        MultivaluedMapImpl form;
        MultivaluedMap parameters;
        block8: {
            parameters = info.getQueryParameters();
            ApplicationContextImpl context = (ApplicationContextImpl)info;
            Type formType = MultivaluedMapImpl.class.getGenericInterfaces()[0];
            MediaType contentType = context.getHttpHeaders().getMediaType();
            if (contentType == null) {
                contentType = MediaType.APPLICATION_FORM_URLENCODED_TYPE;
            }
            form = new MultivaluedMapImpl();
            try {
                MessageBodyReader reader = context.getProviders().getMessageBodyReader(MultivaluedMap.class, formType, null, contentType);
                if (reader != null) {
                    form = (MultivaluedMap)reader.readFrom(MultivaluedMap.class, formType, null, contentType, context.getHttpHeaders().getRequestHeaders(), context.getContainerRequest().getEntityStream());
                }
            }
            catch (IllegalStateException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            catch (WebApplicationException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block8;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        parameters.putAll((Map)form);
        return parameters;
    }
}

