/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.usermodel.AutoShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.VerticalAlignment;

public class HSLFAutoShape
extends HSLFTextShape
implements AutoShape<HSLFShape, HSLFTextParagraph> {
    protected HSLFAutoShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFAutoShape(ShapeType type, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(type, parent instanceof HSLFGroupShape);
    }

    public HSLFAutoShape(ShapeType type) {
        this(type, null);
    }

    protected EscherContainerRecord createSpContainer(ShapeType shapeType, boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        this.setShapeType(shapeType);
        this.setEscherProperty((short)127, 262144);
        this.setEscherProperty((short)385, 0x8000004);
        this.setEscherProperty((short)385, 0x8000004);
        this.setEscherProperty((short)387, 0x8000000);
        this.setEscherProperty((short)447, 0x100010);
        this.setEscherProperty((short)448, 0x8000001);
        this.setEscherProperty((short)511, 524296);
        this.setEscherProperty((short)513, 0x8000002);
        return this._escherContainer;
    }

    @Override
    protected void setDefaultTextProperties(HSLFTextParagraph _txtrun) {
        this.setVerticalAlignment(VerticalAlignment.MIDDLE);
        this.setHorizontalCentered(true);
        this.setWordWrap(2);
    }

    public int getAdjustmentValue(int idx) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        return this.getEscherProperty((short)(327 + idx));
    }

    public void setAdjustmentValue(int idx, int val) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        this.setEscherProperty((short)(327 + idx), val);
    }
}

