/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceListAccess
implements ListAccess<Space> {
    private SpaceStorage spaceStorage;
    private String userId;
    private SpaceFilter spaceFilter;
    Type type;

    public SpaceListAccess() {
        this.spaceStorage = null;
        this.userId = null;
        this.spaceFilter = null;
        this.type = null;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, String userId, SpaceFilter spaceFilter, Type type) {
        this.spaceStorage = spaceStorage;
        this.userId = userId;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, Type type) {
        this.spaceStorage = spaceStorage;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, String userId, Type type) {
        this.spaceStorage = spaceStorage;
        this.userId = userId;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, String userId, String appId, Type type) {
        this.spaceStorage = spaceStorage;
        this.userId = userId;
        this.spaceFilter = new SpaceFilter(userId, appId);
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceFilter spaceFilter, Type type) {
        this.spaceStorage = spaceStorage;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public int getSize() throws Exception {
        switch (this.type) {
            case ALL: {
                return this.spaceStorage.getAllSpacesCount();
            }
            case ALL_FILTER: {
                return this.spaceStorage.getAllSpacesByFilterCount(this.spaceFilter);
            }
            case ACCESSIBLE: {
                return this.spaceStorage.getAccessibleSpacesCount(this.userId);
            }
            case ACCESSIBLE_FILTER: {
                return this.spaceStorage.getAccessibleSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case INVITED: {
                return this.spaceStorage.getInvitedSpacesCount(this.userId);
            }
            case INVITED_FILTER: {
                return this.spaceStorage.getInvitedSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case PENDING: {
                return this.spaceStorage.getPendingSpacesCount(this.userId);
            }
            case PENDING_FILTER: {
                return this.spaceStorage.getPendingSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case PUBLIC: {
                return this.spaceStorage.getPublicSpacesCount(this.userId);
            }
            case PUBLIC_FILTER: {
                return this.spaceStorage.getPublicSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case PUBLIC_SUPER_USER: {
                return 0;
            }
            case SETTING: {
                return this.spaceStorage.getEditableSpacesCount(this.userId);
            }
            case SETTING_FILTER: {
                return this.spaceStorage.getEditableSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case MEMBER: {
                return this.spaceStorage.getMemberSpacesCount(this.userId);
            }
            case MEMBER_FILTER: {
                return this.spaceStorage.getMemberSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case MANAGER: {
                return this.spaceStorage.getManagerSpacesCount(this.userId);
            }
            case MANAGER_FILTER: {
                return this.spaceStorage.getManagerSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case VISIBLE: {
                return this.spaceStorage.getVisibleSpacesCount(this.userId, this.spaceFilter);
            }
            case UNIFIED_SEARCH: {
                return this.spaceStorage.getUnifiedSearchSpacesCount(this.userId, this.spaceFilter);
            }
            case LASTEST_ACCESSED: {
                return this.spaceStorage.getLastAccessedSpaceCount(this.spaceFilter);
            }
            case PENDING_REQUESTS: {
                return this.spaceStorage.countPendingSpaceRequestsToManage(this.userId);
            }
        }
        return 0;
    }

    public Space[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List<Object> listSpaces = null;
        switch (this.type) {
            case ALL: {
                listSpaces = this.spaceStorage.getSpaces(offset, limit);
                break;
            }
            case ALL_FILTER: {
                listSpaces = this.spaceStorage.getSpacesByFilter(this.spaceFilter, offset, limit);
                break;
            }
            case ACCESSIBLE: {
                listSpaces = this.spaceStorage.getAccessibleSpaces(this.userId, offset, limit);
                break;
            }
            case ACCESSIBLE_FILTER: {
                listSpaces = this.spaceStorage.getAccessibleSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case INVITED: {
                listSpaces = this.spaceStorage.getInvitedSpaces(this.userId, offset, limit);
                break;
            }
            case INVITED_FILTER: {
                listSpaces = this.spaceStorage.getInvitedSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case PENDING: {
                listSpaces = this.spaceStorage.getPendingSpaces(this.userId, offset, limit);
                break;
            }
            case PENDING_FILTER: {
                listSpaces = this.spaceStorage.getPendingSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case PUBLIC: {
                listSpaces = this.spaceStorage.getPublicSpaces(this.userId, offset, limit);
                break;
            }
            case PUBLIC_FILTER: {
                listSpaces = this.spaceStorage.getPublicSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case PUBLIC_SUPER_USER: {
                listSpaces = new ArrayList();
                break;
            }
            case SETTING: {
                listSpaces = this.spaceStorage.getEditableSpaces(this.userId, offset, limit);
                break;
            }
            case SETTING_FILTER: {
                listSpaces = this.spaceStorage.getEditableSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case MEMBER: {
                listSpaces = this.spaceStorage.getMemberSpaces(this.userId, offset, limit);
                break;
            }
            case MEMBER_FILTER: {
                listSpaces = this.spaceStorage.getMemberSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case MANAGER: {
                listSpaces = this.spaceStorage.getManagerSpaces(this.userId, offset, limit);
                break;
            }
            case MANAGER_FILTER: {
                listSpaces = this.spaceStorage.getManagerSpacesByFilter(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case VISIBLE: {
                listSpaces = this.spaceStorage.getVisibleSpaces(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case UNIFIED_SEARCH: {
                listSpaces = this.spaceStorage.getUnifiedSearchSpaces(this.userId, this.spaceFilter, offset, limit);
                break;
            }
            case LASTEST_ACCESSED: {
                listSpaces = this.spaceStorage.getLastAccessedSpace(this.spaceFilter, offset, limit);
                break;
            }
            case VISITED: {
                listSpaces = this.spaceStorage.getVisitedSpaces(this.spaceFilter, offset, limit);
                break;
            }
            case PENDING_REQUESTS: {
                List<Space> pendingSpaceRequestsToManage = this.spaceStorage.getPendingSpaceRequestsToManage(this.userId, offset, limit);
                listSpaces = pendingSpaceRequestsToManage.stream().map(space -> {
                    Space storedSpace = this.spaceStorage.getSpaceById(space.getId());
                    storedSpace.setPendingUsers(space.getPendingUsers());
                    return storedSpace;
                }).collect(Collectors.toList());
            }
        }
        return listSpaces.toArray(new Space[listSpaces.size()]);
    }

    public Type gettype() {
        return this.type;
    }

    public void settype(Type type) {
        this.type = type;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static enum Type {
        ALL,
        ALL_FILTER,
        ACCESSIBLE,
        ACCESSIBLE_FILTER,
        INVITED,
        INVITED_FILTER,
        PENDING,
        PENDING_FILTER,
        PUBLIC,
        PUBLIC_FILTER,
        PUBLIC_SUPER_USER,
        SETTING,
        SETTING_FILTER,
        MEMBER,
        MEMBER_FILTER,
        MANAGER,
        MANAGER_FILTER,
        VISIBLE,
        UNIFIED_SEARCH,
        LASTEST_ACCESSED,
        PENDING_REQUESTS,
        VISITED;

    }
}

