/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebNotificationServiceImpl
implements WebNotificationService {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationServiceImpl.class);
    private final WebNotificationStorage storage;

    public WebNotificationServiceImpl(WebNotificationStorage webStorage) {
        this.storage = webStorage;
    }

    public void save(NotificationInfo notification) {
        this.storage.save(notification);
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
    }

    public void markAllRead(String userId) throws Exception {
        this.storage.markAllRead(userId);
    }

    public List<String> get(WebNotificationFilter filter, int offset, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        List<NotificationInfo> gotList = this.getNotificationInfos(filter, offset, limit);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(POPUP_OVER, (Object)filter.isOnPopover());
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        for (NotificationInfo notification : gotList) {
            AbstractTemplateBuilder builder = channel.getTemplateBuilder(notification.getKey());
            MessageInfo msg = null;
            try {
                msg = builder.buildMessage(ctx.setNotificationInfo(notification));
            }
            catch (Exception e) {
                LOG.error((Object)("Error while building message for notification with id = " + notification.getId()), (Throwable)e);
            }
            if (msg != null && msg.getBody() != null && !msg.getBody().isEmpty()) {
                result.add(msg.getBody());
            }
            if (!ctx.isFailed()) continue;
            LOG.warn((Object)ctx.getException().getMessage(), (Throwable)ctx.getException());
        }
        return result;
    }

    public List<NotificationInfo> getNotificationInfos(WebNotificationFilter filter, int offset, int limit) {
        return this.storage.get(filter, offset, limit);
    }

    public boolean remove(String notificationId) {
        return this.storage.remove(notificationId);
    }

    public void hidePopover(String notificationId) {
        this.storage.hidePopover(notificationId);
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
        WebNotificationSender.sendJsonMessage(userId, new MessageInfo().setNumberOnBadge(0));
    }

    public int getNumberOnBadge(String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            try {
                return this.storage.getNumberOnBadge(userId);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)"Exception raising when getNumberOnBadge() ", (Throwable)e);
                } else {
                    LOG.warn((Object)("Exception raising when getNumberOnBadge() associated to the userId " + userId));
                }
                return 0;
            }
        }
        LOG.warn((Object)"Can't getNumberOnBadge(). The userId is null");
        return 0;
    }
}

