/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;

public class GroupPortalConfigListener
extends GroupEventListener {
    private final UserPortalConfigService portalConfigService;
    private final DataStorage dataStorage;
    private final OrganizationService orgService;
    private static Log LOG = ExoLogger.getLogger(GroupPortalConfigListener.class);

    public GroupPortalConfigListener(UserPortalConfigService portalConfigService, OrganizationService orgService, DataStorage dataStorage) {
        this.portalConfigService = portalConfigService;
        this.orgService = orgService;
        this.dataStorage = dataStorage;
    }

    public void preDelete(Group group) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            String groupId = group.getId().trim();
            this.removeGroupNavigation(group);
            this.portalConfigService.removeUserPortalConfig(PortalConfig.GROUP_TYPE, groupId);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            String groupId = group.getId();
            if (groupId == null) {
                groupId = "/" + group.getGroupName();
            }
            if ("/administrators".equals(groupId)) {
                groupId = "/platform/administrators";
            } else if ("/users".equals(groupId)) {
                groupId = "/platform/users";
            } else if ("/guests".equals(groupId)) {
                groupId = "/platform/guests";
            } else if ("/management".equals(groupId)) {
                groupId = "/organization/management";
            } else if ("/executive-board".equals(groupId)) {
                groupId = "/organization/management/executive-board";
            } else if ("/human-resources".equals(groupId)) {
                groupId = "/organization/management/human-resources";
            } else if ("/communication".equals(groupId)) {
                groupId = "/organization/communication";
            } else if ("/marketing".equals(groupId)) {
                groupId = "/organization/communication/marketing";
            } else if ("/press-and-media".equals(groupId)) {
                groupId = "/organization/communication/press-and-media";
            } else if ("/operations".equals(groupId)) {
                groupId = "/organization/operations";
            } else if ("/sales".equals(groupId)) {
                groupId = "/organization/operations/sales";
            } else if ("/finances".equals(groupId)) {
                groupId = "/organization/operations/finances";
            }
            if (this.dataStorage.getPortalConfig(PortalConfig.GROUP_TYPE, groupId) == null) {
                this.portalConfigService.createGroupSite(groupId);
            } else {
                LOG.debug("The group site {} already exists. Ignore creating from listener", new Object[]{groupId});
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void removeGroupNavigation(Group group) throws Exception {
        GroupHandler groupHandler = this.orgService.getGroupHandler();
        Collection<String> descendantGroups = this.getDescendantGroups(group, groupHandler);
        ArrayList<String> deletedNavigationGroups = new ArrayList<String>();
        deletedNavigationGroups.addAll(descendantGroups);
        deletedNavigationGroups.add(group.getId());
        for (String childGroup : deletedNavigationGroups) {
            SiteKey key = SiteKey.group(childGroup);
            NavigationService navService = this.portalConfigService.getNavigationService();
            NavigationContext nav = navService.loadNavigation(key);
            if (nav == null) continue;
            navService.destroyNavigation(nav);
        }
    }

    private Collection<String> getDescendantGroups(Group group, GroupHandler groupHandler) throws Exception {
        Collection groupCollection = groupHandler.findGroups(group);
        ArrayList<String> col = new ArrayList<String>();
        for (Group childGroup : groupCollection) {
            col.add(childGroup.getId());
            col.addAll(this.getDescendantGroups(childGroup, groupHandler));
        }
        return col;
    }
}

