/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteType;

@Entity(name="GateInNavigation")
@ExoEntity
@Table(name="PORTAL_NAVIGATIONS")
@NamedQueries(value={@NamedQuery(name="NavigationEntity.findByOwner", query="SELECT nav FROM GateInNavigation nav INNER JOIN nav.owner s WHERE s.siteType = :ownerType AND s.name = :ownerId"), @NamedQuery(name="NavigationEntity.findByRootNode", query="SELECT nav FROM GateInNavigation nav INNER JOIN nav.rootNode r WHERE r.id = :rootNodeId")})
public class NavigationEntity
implements Serializable {
    private static final long serialVersionUID = 3811683620903785319L;
    @Id
    @SequenceGenerator(name="SEQ_GTN_NAVIGATION_ID", sequenceName="SEQ_GTN_NAVIGATION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GTN_NAVIGATION_ID")
    @Column(name="NAVIGATION_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="SITE_ID")
    private SiteEntity owner;
    @Column(name="PRIORITY")
    private int priority = 1;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JoinColumn(name="NODE_ID")
    private NodeEntity rootNode;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SiteEntity getOwner() {
        return this.owner;
    }

    public void setOwner(SiteEntity owner) {
        this.owner = owner;
    }

    public SiteType getOwnerType() {
        if (this.getOwner() != null) {
            return this.getOwner().getSiteType();
        }
        return null;
    }

    public String getOwnerId() {
        if (this.getOwner() != null) {
            return this.getOwner().getName();
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public NodeEntity getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(NodeEntity rootNode) {
        this.rootNode = rootNode;
    }
}

