/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNodeContext;

public class UserNode {
    final UserNodeContext owner;
    final NodeContext<UserNode> context;
    String uri;

    UserNode(UserNodeContext owner, NodeContext<UserNode> context) {
        this.owner = owner;
        this.context = context;
        this.uri = null;
    }

    public UserNavigation getNavigation() {
        return this.owner.navigation;
    }

    public String getId() {
        return this.context.getId();
    }

    UserNode filter() {
        this.owner.filter(this);
        return this;
    }

    public String getName() {
        return this.context.getName();
    }

    public void setName(String name) {
        this.context.setName(name);
        this.uri = null;
    }

    public String getURI() {
        if (this.uri == null) {
            this.uri = this.buildURI().toString();
        }
        return this.uri;
    }

    private StringBuilder buildURI() {
        UserNode parent = this.context.getParentNode();
        if (parent != null) {
            StringBuilder builder = parent.buildURI();
            if (builder.length() > 0) {
                builder.append('/');
            }
            return builder.append(this.context.getName());
        }
        return new StringBuilder();
    }

    public String getLabel() {
        return this.context.getState().getLabel();
    }

    public void setLabel(String label) {
        this.context.setState(new NodeState.Builder(this.context.getState()).label(label).build());
    }

    public String getIcon() {
        return this.context.getState().getIcon();
    }

    public void setIcon(String icon) {
        this.context.setState(new NodeState.Builder(this.context.getState()).icon(icon).build());
    }

    public long getStartPublicationTime() {
        return this.context.getState().getStartPublicationTime();
    }

    public void setStartPublicationTime(long startPublicationTime) {
        this.context.setState(new NodeState.Builder(this.context.getState()).startPublicationTime(startPublicationTime).build());
    }

    public long getEndPublicationTime() {
        return this.context.getState().getEndPublicationTime();
    }

    public void setEndPublicationTime(long endPublicationTime) {
        this.context.setState(new NodeState.Builder(this.context.getState()).endPublicationTime(endPublicationTime).build());
    }

    public Visibility getVisibility() {
        return this.context.getState().getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        this.context.setState(new NodeState.Builder(this.context.getState()).visibility(visibility).build());
    }

    public PageKey getPageRef() {
        return this.context.getState().getPageRef();
    }

    public void setPageRef(PageKey pageRef) {
        this.context.setState(new NodeState.Builder(this.context.getState()).pageRef(pageRef).build());
    }

    public String getResolvedLabel() {
        String resolvedLabel = null;
        String id = this.context.getId();
        if (this.context.getState().getLabel() != null) {
            ResourceBundle bundle = this.owner.navigation.getBundle();
            resolvedLabel = ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)this.context.getState().getLabel());
        } else if (id != null) {
            Locale userLocale = this.owner.navigation.portal.context.getUserLocale();
            Locale portalLocale = this.owner.navigation.portal.getLocale();
            DescriptionService descriptionService = this.owner.navigation.portal.service.getDescriptionService();
            State description = descriptionService.resolveDescription(id, portalLocale, userLocale);
            if (description != null) {
                resolvedLabel = description.getName();
            }
        }
        if (resolvedLabel == null) {
            resolvedLabel = this.getName();
        }
        return resolvedLabel;
    }

    public void setResolvedLabel(String label) {
        String id = this.context.getId();
        Locale userLocale = this.owner.navigation.portal.context.getUserLocale();
        DescriptionService descriptionService = this.owner.navigation.portal.service.getDescriptionService();
        State description = new State(label, null);
        descriptionService.setDescription(id, userLocale, description);
    }

    public String getEncodedResolvedLabel() {
        return HTMLEntityEncoder.getInstance().encode(this.getResolvedLabel());
    }

    public UserNode getParent() {
        return this.context.getParentNode();
    }

    public boolean hasChildrenRelationship() {
        return this.context.isExpanded();
    }

    public int getChildrenCount() {
        return this.context.getNodeCount();
    }

    public int getChildrenSize() {
        return this.context.getNodeSize();
    }

    public Collection<UserNode> getChildren() {
        return this.context.isExpanded() ? this.context.getNodes() : Collections.emptyList();
    }

    public UserNode getChild(String childName) throws NullPointerException {
        if (this.context.isExpanded()) {
            return this.context.getNode(childName);
        }
        return null;
    }

    public UserNode getChild(int childIndex) throws IndexOutOfBoundsException {
        if (this.context.isExpanded()) {
            return this.context.getNode(childIndex);
        }
        return null;
    }

    public void addChild(UserNode child) {
        this.context.add(null, child.context);
        child.uri = null;
    }

    public void addChild(int index, UserNode child) {
        this.context.add((Integer)index, child.context);
        child.uri = null;
    }

    public UserNode addChild(String childName) {
        return this.context.add(null, childName).getNode();
    }

    public boolean removeChild(String childName) {
        return this.context.removeNode(childName);
    }

    UserNode find(String nodeId) {
        return this.context.getDescendantNode(nodeId);
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int depth) {
        return this.context.toString(depth, new StringBuilder("UserNode[")).append("]").toString();
    }
}

