/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.OEPlaceholderAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.RoundTripHFPlaceholder12;
import org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawTextShape;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.util.Units;

public abstract class HSLFTextShape
extends HSLFSimpleShape
implements TextShape<HSLFShape, HSLFTextParagraph> {
    static final int AnchorTop = 0;
    static final int AnchorMiddle = 1;
    static final int AnchorBottom = 2;
    static final int AnchorTopCentered = 3;
    static final int AnchorMiddleCentered = 4;
    static final int AnchorBottomCentered = 5;
    static final int AnchorTopBaseline = 6;
    static final int AnchorBottomBaseline = 7;
    static final int AnchorTopCenteredBaseline = 8;
    static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    protected List<HSLFTextParagraph> _paragraphs = new ArrayList<HSLFTextParagraph>();
    protected EscherTextboxWrapper _txtbox;
    boolean alignToBaseline = false;
    protected static final FontRenderContext _frc = new FontRenderContext(null, true, true);

    protected HSLFTextShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFTextShape(ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof HSLFGroupShape);
    }

    public HSLFTextShape() {
        this(null);
    }

    protected void setDefaultTextProperties(HSLFTextParagraph _txtrun) {
    }

    @Override
    protected void afterInsert(HSLFSheet sh) {
        super.afterInsert(sh);
        this.storeText();
        EscherTextboxWrapper thisTxtbox = this.getEscherTextboxWrapper();
        if (thisTxtbox != null) {
            this._escherContainer.addChildRecord((EscherRecord)thisTxtbox.getEscherRecord());
            PPDrawing ppdrawing = sh.getPPDrawing();
            ppdrawing.addTextboxWrapper(thisTxtbox);
            try {
                thisTxtbox.writeOut(null);
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
            if (this.getAnchor().equals(new Rectangle()) && !"".equals(this.getText())) {
                this.resizeToFitText();
            }
        }
        for (HSLFTextParagraph htp : this._paragraphs) {
            htp.setShapeId(this.getShapeId());
        }
        sh.onAddTextShape(this);
    }

    protected EscherTextboxWrapper getEscherTextboxWrapper() {
        EscherTextboxWrapper[] wrappers;
        PPDrawing drawing;
        if (this._txtbox != null) {
            return this._txtbox;
        }
        EscherTextboxRecord textRecord = (EscherTextboxRecord)this.getEscherChild(-4083);
        if (textRecord == null) {
            return null;
        }
        HSLFSheet sheet = this.getSheet();
        if (sheet != null && (drawing = sheet.getPPDrawing()) != null && (wrappers = drawing.getTextboxWrappers()) != null) {
            for (EscherTextboxWrapper w : wrappers) {
                if (textRecord != w.getEscherRecord()) continue;
                this._txtbox = w;
                return this._txtbox;
            }
        }
        this._txtbox = new EscherTextboxWrapper(textRecord);
        return this._txtbox;
    }

    public Rectangle2D resizeToFitText() {
        Rectangle anchor = this.getAnchor();
        if (anchor.getWidth() == 0.0) {
            this.logger.log(5, new Object[]{"Width of shape wasn't set. Defaulting to 200px"});
            anchor.setSize(200, (int)anchor.getHeight());
            this.setAnchor(anchor);
        }
        double height = this.getTextHeight();
        anchor.setRect(anchor.getX(), anchor.getY(), anchor.getWidth(), height += 1.0);
        this.setAnchor(anchor);
        return anchor;
    }

    public int getRunType() {
        this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            return -1;
        }
        List<HSLFTextParagraph> paras = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
        return paras.isEmpty() ? -1 : paras.get(0).getRunType();
    }

    public void setRunType(int type) {
        this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            return;
        }
        List<HSLFTextParagraph> paras = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
        if (!paras.isEmpty()) {
            paras.get(0).setRunType(type);
        }
    }

    int getAlignment() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(opt, 135);
        int align = 0;
        if (prop == null) {
            int type = this.getRunType();
            if (this.getSheet() != null && this.getSheet().getMasterSheet() != null) {
                HSLFMasterSheet master = this.getSheet().getMasterSheet();
                HSLFTextShape masterShape = master.getPlaceholderByTextType(type);
                if (masterShape != null) {
                    align = masterShape.getAlignment();
                }
            } else {
                switch (type) {
                    case 0: 
                    case 6: {
                        align = 1;
                        break;
                    }
                    default: {
                        align = 0;
                    }
                }
            }
        } else {
            align = prop.getPropertyValue();
        }
        this.alignToBaseline = align == 7 || align == 9 || align == 6 || align == 8;
        return align;
    }

    void setAlignment(Boolean isCentered, VerticalAlignment vAlign) {
        int[] align;
        switch (vAlign) {
            case TOP: {
                align = new int[]{0, 3, 6, 8};
                break;
            }
            default: {
                align = new int[]{1, 4, 1, 4};
                break;
            }
            case BOTTOM: {
                align = new int[]{2, 5, 7, 9};
            }
        }
        int align2 = align[(isCentered != false ? 1 : 0) + (this.alignToBaseline ? 2 : 0)];
        this.setEscherProperty((short)135, align2);
    }

    public VerticalAlignment getVerticalAlignment() {
        int va = this.getAlignment();
        switch (va) {
            case 0: 
            case 3: 
            case 6: 
            case 8: {
                return VerticalAlignment.TOP;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                return VerticalAlignment.BOTTOM;
            }
        }
        return VerticalAlignment.MIDDLE;
    }

    public boolean isAlignToBaseline() {
        this.getAlignment();
        return this.alignToBaseline;
    }

    public void setAlignToBaseline(boolean alignToBaseline) {
        this.alignToBaseline = alignToBaseline;
        this.setAlignment(this.isHorizontalCentered(), this.getVerticalAlignment());
    }

    public boolean isHorizontalCentered() {
        int va = this.getAlignment();
        switch (va) {
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setVerticalAlignment(VerticalAlignment vAlign) {
        this.setAlignment(this.isHorizontalCentered(), vAlign);
    }

    public void setHorizontalCentered(Boolean isCentered) {
        this.setAlignment(isCentered, this.getVerticalAlignment());
    }

    public double getBottomInset() {
        return this.getInset((short)132, 0.05);
    }

    public void setBottomInset(double margin) {
        this.setInset((short)132, margin);
    }

    public double getLeftInset() {
        return this.getInset((short)129, 0.1);
    }

    public void setLeftInset(double margin) {
        this.setInset((short)129, margin);
    }

    public double getRightInset() {
        return this.getInset((short)131, 0.1);
    }

    public void setRightInset(double margin) {
        this.setInset((short)131, margin);
    }

    public double getTopInset() {
        return this.getInset((short)130, 0.05);
    }

    public void setTopInset(double margin) {
        this.setInset((short)130, margin);
    }

    private double getInset(short propId, double defaultInch) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(opt, propId);
        int val = prop == null ? (int)((double)Units.toEMU((double)72.0) * defaultInch) : prop.getPropertyValue();
        return Units.toPoints((long)val);
    }

    private void setInset(short propId, double margin) {
        this.setEscherProperty(propId, Units.toEMU((double)margin));
    }

    public boolean getWordWrap() {
        int ww = this.getWordWrapEx();
        return ww != 2;
    }

    public int getWordWrapEx() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(opt, 133);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setWordWrap(int wrap) {
        this.setEscherProperty((short)133, wrap);
    }

    public int getTextId() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(opt, 128);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setTextId(int id) {
        this.setEscherProperty((short)128, id);
    }

    public List<HSLFTextParagraph> getTextParagraphs() {
        if (!this._paragraphs.isEmpty()) {
            return this._paragraphs;
        }
        this._txtbox = this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            this._paragraphs.addAll(HSLFTextParagraph.createEmptyParagraph());
            this._txtbox = this._paragraphs.get(0).getTextboxWrapper();
        } else {
            this._paragraphs = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
            if (this._paragraphs == null) {
                this._paragraphs = HSLFTextParagraph.createEmptyParagraph(this._txtbox);
            }
            if (this._paragraphs.isEmpty()) {
                this.logger.log(5, new Object[]{"TextRecord didn't contained any text lines"});
            }
        }
        for (HSLFTextParagraph p : this._paragraphs) {
            p.setParentShape(this);
        }
        return this._paragraphs;
    }

    @Override
    public void setSheet(HSLFSheet sheet) {
        this._sheet = sheet;
        List<HSLFTextParagraph> paras = this.getTextParagraphs();
        if (paras != null) {
            for (HSLFTextParagraph htp : paras) {
                htp.supplySheet(this._sheet);
            }
        }
    }

    public OEPlaceholderAtom getPlaceholderAtom() {
        return (OEPlaceholderAtom)this.getClientDataRecord(RecordTypes.OEPlaceholderAtom.typeID);
    }

    public void setHyperlink(int linkId, int beginIndex, int endIndex) {
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        infoAtom.setAction((byte)4);
        infoAtom.setHyperlinkType((byte)8);
        infoAtom.setHyperlinkID(linkId);
        this._txtbox.appendChildRecord(info);
        TxInteractiveInfoAtom txiatom = new TxInteractiveInfoAtom();
        txiatom.setStartIndex(beginIndex);
        txiatom.setEndIndex(endIndex);
        this._txtbox.appendChildRecord(txiatom);
    }

    @Override
    public boolean isPlaceholder() {
        OEPlaceholderAtom oep = this.getPlaceholderAtom();
        if (oep != null) {
            return true;
        }
        RoundTripHFPlaceholder12 hldr = (RoundTripHFPlaceholder12)this.getClientDataRecord(RecordTypes.RoundTripHFPlaceholder12.typeID);
        return hldr != null;
    }

    public Iterator<HSLFTextParagraph> iterator() {
        return this._paragraphs.iterator();
    }

    public Insets2D getInsets() {
        Insets2D insets = new Insets2D(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
        return insets;
    }

    public double getTextHeight() {
        DrawFactory drawFact = DrawFactory.getInstance(null);
        DrawTextShape dts = drawFact.getDrawable((TextShape)this);
        return dts.getTextHeight();
    }

    public TextShape.TextDirection getTextDirection() {
        return TextShape.TextDirection.HORIZONTAL;
    }

    public String getRawText() {
        return HSLFTextParagraph.getRawText(this.getTextParagraphs());
    }

    public String getText() {
        String rawText = this.getRawText();
        return HSLFTextParagraph.toExternalString(rawText, this.getRunType());
    }

    public HSLFTextRun appendText(String text, boolean newParagraph) {
        List<HSLFTextParagraph> paras = this.getTextParagraphs();
        return HSLFTextParagraph.appendText(paras, text, newParagraph);
    }

    public HSLFTextRun setText(String text) {
        List<HSLFTextParagraph> paras = this.getTextParagraphs();
        HSLFTextRun htr = HSLFTextParagraph.setText(paras, text);
        this.setTextId(text.hashCode());
        return htr;
    }

    protected void storeText() {
        List<HSLFTextParagraph> paras = this.getTextParagraphs();
        HSLFTextParagraph.storeText(paras);
    }

    public List<HSLFHyperlink> getHyperlinks() {
        return HSLFHyperlink.find(this);
    }
}

