/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UIInvitation;
import org.exoplatform.social.webui.space.UISpaceSettings;
import org.exoplatform.social.webui.space.UISpaceTemplateDescription;
import org.exoplatform.social.webui.space.UISpaceVisibility;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={CreateActionListener.class}), @EventConfig(listeners={ChangeTemplateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOptionActionListener.class}, phase=Event.Phase.DECODE)})
public class UISpaceAddForm
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UISpaceAddForm.class);
    private static final String MSG_ERROR_SPACE_CREATION = "UISpaceAddForm.msg.error_space_creation";
    private static final String MSG_ERROR_DATASTORE = "UISpaceAddForm.msg.error_space_not_saved";
    private static final String MSG_ERROR_UNABLE_TO_INIT_APP = "UISpaceAddForm.msg.error_unable_to_init_app";
    private static final String MSG_ERROR_UNABLE_TO_ADD_CREATOR = "UISpaceAddForm.msg.error_unable_to_add_creator";
    private static final String MSG_ERROR_UNABLE_TO_ADD_APPLICATION = "UISpaceAddForm.msg.error_unable_to_add_application";
    private static final String MSG_ERROR_RETRIEVING_USER = "UISpaceAddForm.msg.error_unable_to_retrieve_user";
    private static final String MSG_SPACE_CREATION_SUCCESS = "UISpaceAddForm.msg.space_creation_success";
    private static final String MSG_ERROR_SPACE_ALREADY_EXIST = "UISpaceAddForm.msg.error_space_already_exist";
    private static final String MSG_ERROR_SPACE_PERMISSION = "UISpaceAddForm.msg.error_space_permission";
    private final String SPACE_SETTINGS = "UISpaceSettings";
    private final String SPACE_VISIBILITY = "UISpaceVisibility";

    public UISpaceAddForm() throws Exception {
        UISpaceSettings uiSpaceSettings = new UISpaceSettings("UISpaceSettings");
        this.addChild((UIComponent)uiSpaceSettings);
        UISpaceVisibility uiSpaceVisibility = new UISpaceVisibility("UISpaceVisibility");
        this.addChild((UIComponent)uiSpaceVisibility);
        this.addChild(UIInvitation.class, null, null);
        this.setActions(new String[]{"Create"});
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        String selectedTemplate;
        UIInvitation uiInvitation = (UIInvitation)this.getChild(UIInvitation.class);
        UIFormSelectBox uiFormSelectBox = this.getUIFormSelectBox("template");
        UISpaceVisibility uiSpaceVisibility = (UISpaceVisibility)this.getChild(UISpaceVisibility.class);
        SpaceTemplateService spaceTemplateService = (SpaceTemplateService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceTemplateService.class);
        SpaceTemplate spaceTemplate = spaceTemplateService.getSpaceTemplateByName(selectedTemplate = (String)uiFormSelectBox.getValue());
        String invitees = spaceTemplate.getInvitees();
        if (StringUtils.isNotBlank((String)invitees)) {
            uiInvitation.setInvitees(invitees);
        }
        ResourceBundle resourceBundle = context.getApplicationResourceBundle();
        String visibility = spaceTemplate.getVisibility();
        String registration = spaceTemplate.getRegistration();
        uiSpaceVisibility.setVisibility(visibility);
        uiSpaceVisibility.setVisibilityInfo(resourceBundle, visibility);
        UIFormRadioBoxInput selectRegistration = (UIFormRadioBoxInput)uiSpaceVisibility.getChildById("UIRegistration");
        selectRegistration.setValue((Object)registration);
        uiSpaceVisibility.setRegistrationInfo(resourceBundle, registration);
        super.processRender(context);
    }

    public String getLabel(ResourceBundle res, String key) {
        return new StringBuffer(super.getLabel(res, key)).append(key.indexOf("action.") < 0 ? ":" : "").toString();
    }

    public static class ChangeTemplateActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            UISpaceSettings uiSpaceSettings = (UISpaceSettings)uiSpaceAddForm.getChild(UISpaceSettings.class);
            String templateName = (String)uiSpaceSettings.getUIFormSelectBox("template").getValue();
            SpaceTemplateService spaceTemplateService = (SpaceTemplateService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceTemplateService.class);
            SpaceTemplate spaceTemplate = spaceTemplateService.getSpaceTemplateByName(templateName);
            String visibility = spaceTemplate.getVisibility();
            String registration = spaceTemplate.getRegistration();
            String invitees = spaceTemplate.getInvitees();
            UISpaceVisibility uiSpaceVisibility = (UISpaceVisibility)uiSpaceAddForm.findFirstComponentOfType(UISpaceVisibility.class);
            UISpaceTemplateDescription uiSpaceTemplateDescription = (UISpaceTemplateDescription)uiSpaceSettings.getChild(UISpaceTemplateDescription.class);
            UIFormRadioBoxInput uiRegistration = (UIFormRadioBoxInput)uiSpaceVisibility.findComponentById("UIRegistration");
            uiSpaceTemplateDescription.setTemplateName(templateName);
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resourceBundle = ctx.getApplicationResourceBundle();
            uiSpaceVisibility.setVisibility(visibility);
            uiSpaceVisibility.setVisibilityInfo(resourceBundle, visibility);
            uiRegistration.setValue((Object)registration);
            uiSpaceVisibility.setRegistrationInfo(resourceBundle, registration);
            UIInvitation uiInvitation = (UIInvitation)uiSpaceAddForm.findFirstComponentOfType(UIInvitation.class);
            if (StringUtils.isNotBlank((String)invitees)) {
                uiInvitation.setInvitees(invitees);
            } else {
                uiInvitation.setInvitees("");
            }
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiInvitation);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceTemplateDescription);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceVisibility);
        }
    }

    public static class ChangeOptionActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            UISpaceVisibility uiSpaceVisibility = (UISpaceVisibility)uiSpaceAddForm.getChildById("UISpaceVisibility");
            UIFormRadioBoxInput selectRegistration = (UIFormRadioBoxInput)uiSpaceVisibility.getChildById("UIRegistration");
            String currentRegistration = (String)selectRegistration.getValue();
            uiSpaceVisibility.setRegistrationInfo(resApp, currentRegistration);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceVisibility);
        }
    }

    public static class CreateActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApplication = ctx.getUIApplication();
            SpaceService spaceService = (SpaceService)uiAddForm.getApplicationComponent(SpaceService.class);
            SpacesAdministrationService spacesAdministrationService = (SpacesAdministrationService)CommonsUtils.getService(SpacesAdministrationService.class);
            UIInvitation uiInvitation = (UIInvitation)uiAddForm.getChild(UIInvitation.class);
            List<Identity> invitedIdentities = uiInvitation.getSelectedIdentities();
            List<String> notFoundList = uiInvitation.getNotFoundInvitees();
            if (notFoundList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean isSeparated = false;
                for (String i : notFoundList) {
                    if (isSeparated) {
                        sb.append(", ");
                    }
                    sb.append("'").append(i).append("'");
                    isSeparated = true;
                }
                uiApplication.addMessage(new ApplicationMessage("UIUserInvitation.msg.invalid-input", (Object[])new String[]{sb.toString()}, 0));
                return;
            }
            String creator = ctx.getRemoteUser();
            Space space = new Space();
            uiAddForm.invokeSetBindingBean(space);
            space.setDisplayName(space.getDisplayName().trim());
            String spaceDisplayName = (String)uiAddForm.getUIStringInput("displayName").getValue();
            String spaceDescription = (String)uiAddForm.getUIFormTextAreaInput("description").getValue();
            String spaceVisibility = ((UISpaceVisibility)uiAddForm.findFirstComponentOfType(UISpaceVisibility.class)).getVisibility();
            space.setDisplayName(spaceDisplayName.trim());
            space.setDescription(StringEscapeUtils.escapeHtml((String)spaceDescription));
            space.setPrettyName(space.getDisplayName());
            space.setVisibility(spaceVisibility);
            String msg = UISpaceAddForm.MSG_SPACE_CREATION_SUCCESS;
            try {
                Space got;
                SpaceUtils.checkUserExisting((String)ctx.getRemoteUser());
                if (spaceService.getSpaceByDisplayName(space.getDisplayName()) != null) {
                    throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
                }
                String prettyName = space.getPrettyName();
                int count = 1;
                while ((got = spaceService.getSpaceByPrettyName(prettyName)) != null) {
                    if (count == 1 && got.getDisplayName().equalsIgnoreCase(space.getDisplayName())) {
                        throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
                    }
                    prettyName = space.getPrettyName() + "_" + count;
                    ++count;
                }
                space.setPrettyName(prettyName);
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
                Identity identity = idm.getOrCreateIdentity("space", space.getPrettyName(), true);
                if (identity != null) {
                    space.setPrettyName(SpaceUtils.buildPrettyName((Space)space));
                }
                if (!spacesAdministrationService.canCreateSpace(ctx.getRemoteUser())) {
                    throw new SpaceException(SpaceException.Code.SPACE_PERMISSION);
                }
                space = invitedIdentities != null ? spaceService.createSpace(space, creator, invitedIdentities) : spaceService.createSpace(space, creator);
            }
            catch (SpaceException se) {
                if (se.getCode() == SpaceException.Code.SPACE_ALREADY_EXIST) {
                    msg = UISpaceAddForm.MSG_ERROR_SPACE_ALREADY_EXIST;
                    uiApplication.addMessage(new ApplicationMessage(msg, null, 1));
                    return;
                }
                if (se.getCode() == SpaceException.Code.SPACE_PERMISSION) {
                    msg = UISpaceAddForm.MSG_ERROR_SPACE_PERMISSION;
                    uiApplication.addMessage(new ApplicationMessage(msg, null, 1));
                    return;
                }
                msg = se.getCode() == SpaceException.Code.UNABLE_TO_ADD_CREATOR ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_CREATOR : (se.getCode() == SpaceException.Code.ERROR_DATASTORE ? UISpaceAddForm.MSG_ERROR_DATASTORE : (se.getCode() == SpaceException.Code.UNABLE_TO_INIT_APP ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_INIT_APP : (se.getCode() == SpaceException.Code.UNABLE_TO_ADD_APPLICATION ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_APPLICATION : (se.getCode() == SpaceException.Code.ERROR_RETRIEVING_USER ? UISpaceAddForm.MSG_ERROR_RETRIEVING_USER : UISpaceAddForm.MSG_ERROR_SPACE_CREATION))));
                LOG.error((Object)"Failed to create a new space", (Throwable)se);
                uiApplication.addMessage(new ApplicationMessage(msg, null, 0));
                return;
            }
            SpaceUtils.restartRequest();
            UIPopupWindow uiPopup = (UIPopupWindow)uiAddForm.getParent();
            uiPopup.setUIComponent(null);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            Utils.updateWorkingWorkSpace();
            JavascriptManager jsManager = ctx.getJavascriptManager();
            jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
        }
    }
}

