/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.checker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.job.FileStorageCleanJob;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="FileStorageCheckController")})
@ManagedDescription(value="File Storage Check consistency")
public class FileStorageCheckController
implements Startable {
    protected static Log LOG = ExoLogger.getLogger(FileStorageCheckController.class);
    public static final String REPORT_CONSISTENT_MESSAGE = "File Storage data is consistent";
    public static final String REPORT_NOT_CONSISTENT_MESSAGE = "File Storage data is NOT consistent";
    private static final int pageSize = 20;
    private BinaryProvider binaryProvider;
    private DataStorage dataStorage;

    public FileStorageCheckController(DataStorage dataStorage, BinaryProvider resourceProvider) {
        this.dataStorage = dataStorage;
        this.binaryProvider = resourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Check File Storage consistency. ")
    public String checkFileStorage() {
        boolean defaultState = FileStorageCleanJob.isEnabled().get();
        try {
            final Report report = new Report();
            if (FileStorageCleanJob.isEnabled().get()) {
                FileStorageCleanJob.setEnabled(false);
            }
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        List<FileInfo> list;
                        LOG.info((Object)"Start File Storage Check Consistency");
                        boolean isConsistent = true;
                        int offset = 0;
                        boolean hasNext = true;
                        while (hasNext && (list = FileStorageCheckController.this.dataStorage.getAllFilesInfo(offset, 20)) != null && !list.isEmpty()) {
                            if (list.size() < 20) {
                                hasNext = false;
                            }
                            for (FileInfo fileInfo : list) {
                                String checksum = fileInfo.getChecksum();
                                if (checksum != null && !checksum.isEmpty()) {
                                    if (FileStorageCheckController.this.binaryProvider.exists(checksum)) continue;
                                    isConsistent = false;
                                    report.writeLine("File not exist in file storage File ID : " + fileInfo.getId() + " File name : " + fileInfo.getName() + " , Path : " + FileStorageCheckController.this.binaryProvider.getFilePath(fileInfo.getChecksum()));
                                    continue;
                                }
                                isConsistent = false;
                                report.writeLine("File metaData with empty checksum File ID : " + fileInfo.getId() + " File name : " + fileInfo.getName() + " , Path : ");
                            }
                            offset += 20;
                        }
                        if (isConsistent) {
                            report.writeLine(FileStorageCheckController.REPORT_CONSISTENT_MESSAGE);
                            LOG.info((Object)"Finish File Storage Check Consistency : File Storage data is consistent");
                        } else {
                            report.writeLine(FileStorageCheckController.REPORT_NOT_CONSISTENT_MESSAGE);
                            LOG.info((Object)"Finish File Storage Check Consistency : File Storage data is NOT consistent");
                        }
                    }
                    catch (Exception e) {
                        try {
                            report.writeLine("Processing File Storage Check Consistency Error ");
                            report.writeStackTrace(e);
                        }
                        catch (IOException e1) {
                            LOG.error((Object)e1.getMessage());
                        }
                        LOG.error((Object)e.getMessage());
                    }
                    return true;
                }
            });
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
            String string = "Failed Operation";
            return string;
        }
        finally {
            FileStorageCleanJob.setEnabled(defaultState);
        }
        return "Success Operation";
    }

    @Managed
    @ManagedDescription(value="Check File Storage consistency. ")
    public String RepairFileStorage() {
        return "Unsupported Operation";
    }

    public void start() {
    }

    public void stop() {
    }

    private class Report {
        private static final String DELIMITER = "\n";
        private Writer writer;
        private String reportPath;

        public Report() throws IOException {
            String reportPathRoot = PropertyManager.getProperty((String)"java.io.tmpdir");
            final File reportFile = new File(reportPathRoot, "report-filesStorage-" + new SimpleDateFormat("dd-MMM-yy-HH-mm").format(new Date()) + ".txt");
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Report.this.reportPath = reportFile.getAbsolutePath();
                    Report.this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(Report.this.reportPath)));
                    return null;
                }
            });
        }

        private void writeLine(String message) throws IOException {
            this.writer.write(message);
            this.writer.write(DELIMITER);
            this.writer.flush();
        }

        private void writeStackTrace(Throwable e) throws IOException {
            this.writeLine(e.getMessage());
            this.writeLine(e.toString());
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                this.writeLine("\tat " + trace[i]);
            }
            Throwable ourCause = e.getCause();
            if (ourCause != null) {
                this.writeLine("Cause:");
                this.writeStackTrace(ourCause);
            }
        }
    }
}

