/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.web;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure1;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure11;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure13;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure15;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure17;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure19;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure21;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure23;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure25;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure27;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure3;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure5;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure7;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure9;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebParamsEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JPAWebNotificationStorage
implements WebNotificationStorage {
    private static final Log LOG;
    private final UserSettingService userSettingService;
    private WebNotifDAO webNotifDAO;
    private WebParamsDAO webParamsDAO;
    private WebUsersDAO webUsersDAO;
    private static final String NTF_NAME_SPACE = "ntf:";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public JPAWebNotificationStorage(WebNotifDAO webNotifDAO, WebParamsDAO webParamsDAO, WebUsersDAO webUsersDAO, UserSettingService userSettingService) {
        this.userSettingService = userSettingService;
        this.webNotifDAO = webNotifDAO;
        this.webParamsDAO = webParamsDAO;
        this.webUsersDAO = webUsersDAO;
    }

    @ExoTransactional
    public void save(NotificationInfo notification) {
        NotificationInfo notificationInfo = notification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)notificationInfo);
        Object[] objectArray = new Object[]{this, notificationInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<NotificationInfo> get(WebNotificationFilter filter, int offset, int limit) {
        WebNotificationFilter webNotificationFilter = filter;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{webNotificationFilter, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, webNotificationFilter, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public NotificationInfo get(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (NotificationInfo)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public boolean remove(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public boolean remove(long seconds) {
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public boolean remove(String userId, long seconds) {
        String string = userId;
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, string, Conversions.longObject((long)l), joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public void markRead(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void hidePopover(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void markAllRead(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String userId) {
        String string = pluginId;
        String string2 = activityId;
        String string3 = userId;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        return (NotificationInfo)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void update(NotificationInfo notification, boolean moveTop) {
        NotificationInfo notificationInfo = notification;
        boolean bl = moveTop;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)notificationInfo, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, notificationInfo, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public int getNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public void resetNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void save(NotificationInfo notification, boolean moveTop) {
        WebUsersEntity webUsersEntity = null;
        if (notification.getId() != null && !notification.getId().startsWith("NotificationMessage")) {
            webUsersEntity = (WebUsersEntity)this.webUsersDAO.find(Long.valueOf(Long.parseLong(notification.getId())));
        }
        boolean isNew = webUsersEntity == null;
        WebNotifEntity webNotifEntity = null;
        if (isNew) {
            webNotifEntity = new WebNotifEntity();
            webUsersEntity = new WebUsersEntity();
        } else {
            webNotifEntity = webUsersEntity.getNotification();
        }
        webNotifEntity.setType(notification.getKey().getId());
        webNotifEntity.setText(notification.getTitle());
        webNotifEntity.setSender(notification.getFrom());
        if (notification.getDateCreated() == null) {
            webNotifEntity.setCreationDate(Calendar.getInstance());
        } else {
            webNotifEntity.setCreationDate(notification.getDateCreated());
        }
        webNotifEntity = isNew ? (WebNotifEntity)this.webNotifDAO.create(webNotifEntity) : (WebNotifEntity)this.webNotifDAO.update(webNotifEntity);
        Map ownerParameter = notification.getOwnerParameter();
        Set<WebParamsEntity> parameters = webNotifEntity.getParameters();
        if (ownerParameter != null && !ownerParameter.isEmpty()) {
            for (String key : ownerParameter.keySet()) {
                String propertyName = key.replace(NTF_NAME_SPACE, "");
                WebParamsEntity webParamsEntity = null;
                boolean isParamNew = true;
                if (isNew) {
                    webParamsEntity = new WebParamsEntity();
                } else {
                    for (WebParamsEntity webParamsEntityTmp : parameters) {
                        if (!webParamsEntityTmp.getName().equals(propertyName)) continue;
                        webParamsEntity = webParamsEntityTmp;
                        isParamNew = false;
                        break;
                    }
                }
                if (webParamsEntity == null) {
                    webParamsEntity = new WebParamsEntity();
                }
                webParamsEntity.setName(propertyName);
                webParamsEntity.setValue((String)ownerParameter.get(key));
                webParamsEntity.setNotification(webNotifEntity);
                if (isParamNew) {
                    this.webParamsDAO.create(webParamsEntity);
                    continue;
                }
                this.webParamsDAO.update(webParamsEntity);
            }
        }
        webUsersEntity.setReceiver(notification.getTo());
        Calendar calendar = Calendar.getInstance();
        if (moveTop) {
            webUsersEntity.setUpdateDate(calendar);
        } else if (notification.getLastModifiedDate() > 0L) {
            calendar.setTimeInMillis(notification.getLastModifiedDate());
            webUsersEntity.setUpdateDate(calendar);
        } else {
            webUsersEntity.setUpdateDate(webNotifEntity.getCreationDate());
        }
        webUsersEntity.setShowPopover(notification.isOnPopOver());
        webUsersEntity.setResetNumberOnBadge(notification.isResetOnBadge());
        webUsersEntity.setRead(notification.isRead());
        webUsersEntity.setNotification(webNotifEntity);
        if (isNew) {
            webUsersEntity = (WebUsersEntity)this.webUsersDAO.create(webUsersEntity);
            notification.setId(String.valueOf(webUsersEntity.getId()));
        } else {
            this.webUsersDAO.update(webUsersEntity);
        }
    }

    private long parseNotificationId(String notificationId) {
        return Long.parseLong(notificationId);
    }

    @ExoTransactional
    private WebUsersEntity getWebNotification(Long notificationId) {
        Long l = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)l);
        Object[] objectArray = new Object[]{this, l, joinPoint};
        return (WebUsersEntity)ExoTransactionalAspect.aspectOf().around(new JPAWebNotificationStorage$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
    }

    public NotificationInfo convertWebNotifEntityToNotificationInfo(WebUsersEntity webUsersEntity) {
        NotificationInfo notificationInfo = new NotificationInfo();
        WebNotifEntity notification = webUsersEntity.getNotification();
        notificationInfo.setLastModifiedDate(webUsersEntity.getUpdateDate());
        Set<WebParamsEntity> parameters = notification.getParameters();
        Map<String, String> ownerParameters = parameters.stream().collect(Collectors.toMap(WebParamsEntity::getName, value -> value.getValue() == null ? "" : value.getValue()));
        ownerParameters.put(NotificationMessageUtils.READ_PORPERTY.getKey(), String.valueOf(webUsersEntity.isRead()));
        notificationInfo.setOwnerParameter(ownerParameters);
        notificationInfo.key(new PluginKey(notification.getType()));
        notificationInfo.setTitle(notification.getText());
        notificationInfo.setFrom(notification.getSender());
        notificationInfo.to(webUsersEntity.getReceiver());
        notificationInfo.setRead(webUsersEntity.isRead());
        notificationInfo.setOnPopOver(webUsersEntity.isShowPopover());
        notificationInfo.setResetOnBadge(webUsersEntity.isResetNumberOnBadge());
        notificationInfo.setDateCreated(notification.getCreationDate());
        notificationInfo.setId(String.valueOf(webUsersEntity.getId()));
        return notificationInfo;
    }

    static {
        JPAWebNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPAWebNotificationStorage.class);
    }

    static /* synthetic */ void save_aroundBody0(JPAWebNotificationStorage ajc$this, NotificationInfo notification, JoinPoint joinPoint) {
        ajc$this.save(notification, false);
    }

    static /* synthetic */ List get_aroundBody2(JPAWebNotificationStorage ajc$this, WebNotificationFilter filter, int offset, int limit, JoinPoint joinPoint) {
        ArrayList<NotificationInfo> result = new ArrayList<NotificationInfo>();
        String pluginId = filter.getPluginKey() != null ? filter.getPluginKey().getId() : null;
        String userId = filter.getUserId();
        Pair parameter = filter.getParameter();
        String paramName = null;
        String paramValue = null;
        if (parameter != null) {
            paramName = (String)parameter.getKey();
            paramValue = (String)parameter.getValue();
        }
        List<WebUsersEntity> webUsersEntities = paramName != null && paramValue != null && pluginId != null ? ajc$this.webUsersDAO.findNotificationsByTypeAndParams(pluginId, paramName, paramValue, userId, offset, limit) : (pluginId != null ? ajc$this.webUsersDAO.findWebNotifsByFilter(pluginId, userId, filter.isOnPopover(), offset, limit) : (filter.isOnPopover() ? ajc$this.webUsersDAO.findWebNotifsByFilter(userId, filter.isOnPopover(), offset, limit) : ajc$this.webUsersDAO.findWebNotifsByFilter(userId, offset, limit)));
        for (WebUsersEntity webUserNotifEntity : webUsersEntities) {
            result.add(ajc$this.convertWebNotifEntityToNotificationInfo(webUserNotifEntity));
        }
        return result;
    }

    static /* synthetic */ NotificationInfo get_aroundBody4(JPAWebNotificationStorage ajc$this, String id, JoinPoint joinPoint) {
        if (StringUtils.isBlank((String)id) || id.startsWith("NotificationMessage")) {
            return null;
        }
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(id));
        if (webUsersEntity != null) {
            return ajc$this.convertWebNotifEntityToNotificationInfo(webUsersEntity);
        }
        return null;
    }

    static /* synthetic */ boolean remove_aroundBody6(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(notificationId));
        if (webUsersEntity != null) {
            ajc$this.webUsersDAO.delete(webUsersEntity);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean remove_aroundBody8(JPAWebNotificationStorage ajc$this, long seconds, JoinPoint joinPoint) {
        boolean removed = false;
        Calendar cal = Calendar.getInstance();
        long delayTime = System.currentTimeMillis() - seconds * 1000L;
        cal.setTimeInMillis(delayTime);
        ArrayList<WebNotifEntity> notifEntities = new ArrayList<WebNotifEntity>();
        List<WebUsersEntity> webUserNotifs = ajc$this.webUsersDAO.findWebNotifsByLastUpdatedDate(cal);
        for (WebUsersEntity webUsersEntity : webUserNotifs) {
            WebNotifEntity notification = webUsersEntity.getNotification();
            if (!notifEntities.contains(notification)) {
                notifEntities.add(notification);
            }
            ajc$this.webUsersDAO.delete(webUsersEntity);
        }
        boolean bl = removed = notifEntities.size() > 0;
        if (removed) {
            for (WebNotifEntity webNotifEntity : notifEntities) {
                ajc$this.webParamsDAO.deleteAll(new ArrayList<WebParamsEntity>(webNotifEntity.getParameters()));
            }
            ajc$this.webNotifDAO.deleteAll(notifEntities);
        }
        return removed;
    }

    static /* synthetic */ boolean remove_aroundBody10(JPAWebNotificationStorage ajc$this, String userId, long seconds, JoinPoint joinPoint) {
        Calendar calendar = Calendar.getInstance();
        long timeInMilliseconds = calendar.getTimeInMillis() - seconds * 1000L;
        calendar.setTimeInMillis(timeInMilliseconds);
        boolean removed = false;
        for (WebUsersEntity webUsersEntity : ajc$this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate(userId, calendar)) {
            try {
                ajc$this.webUsersDAO.delete(webUsersEntity);
                removed = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove notification with id '" + webUsersEntity.getId() + "' for the user id: " + userId), (Throwable)e);
                return false;
            }
        }
        return removed;
    }

    static /* synthetic */ void markRead_aroundBody12(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        long notifIdLong = ajc$this.parseNotificationId(notificationId);
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(Long.valueOf(notifIdLong));
        if (webUsersEntity != null) {
            webUsersEntity.setRead(true);
            ajc$this.webUsersDAO.update(webUsersEntity);
        }
    }

    static /* synthetic */ void hidePopover_aroundBody14(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(Long.valueOf(ajc$this.parseNotificationId(notificationId)));
        if (webUsersEntity != null) {
            webUsersEntity.setShowPopover(false);
            ajc$this.webUsersDAO.update(webUsersEntity);
        }
    }

    static /* synthetic */ void markAllRead_aroundBody16(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        ajc$this.webUsersDAO.markAllRead(userId);
        ajc$this.userSettingService.saveLastReadDate(userId, Long.valueOf(System.currentTimeMillis()));
    }

    static /* synthetic */ NotificationInfo getUnreadNotification_aroundBody18(JPAWebNotificationStorage ajc$this, String pluginId, String activityId, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> list = ajc$this.webUsersDAO.findUnreadNotification(pluginId, userId, "activityId", activityId);
        if (!list.isEmpty()) {
            WebUsersEntity webUsersNotification = list.get(0);
            return ajc$this.convertWebNotifEntityToNotificationInfo(webUsersNotification);
        }
        return null;
    }

    static /* synthetic */ void update_aroundBody20(JPAWebNotificationStorage ajc$this, NotificationInfo notification, boolean moveTop, JoinPoint joinPoint) {
        ajc$this.save(notification, moveTop);
    }

    static /* synthetic */ int getNumberOnBadge_aroundBody22(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        return ajc$this.webUsersDAO.getNumberOnBadge(userId);
    }

    static /* synthetic */ void resetNumberOnBadge_aroundBody24(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> notifsWithBadge = ajc$this.webUsersDAO.findNotifsWithBadge(userId);
        if (notifsWithBadge != null && notifsWithBadge.size() > 0) {
            for (WebUsersEntity webUsersEntity : notifsWithBadge) {
                webUsersEntity.setResetNumberOnBadge(true);
            }
            ajc$this.webUsersDAO.updateAll(notifsWithBadge);
        }
    }

    static /* synthetic */ WebUsersEntity getWebNotification_aroundBody26(JPAWebNotificationStorage ajc$this, Long notificationId, JoinPoint joinPoint) {
        return (WebUsersEntity)ajc$this.webUsersDAO.find(notificationId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAWebNotificationStorage.java", JPAWebNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo", "notification", "", "void"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.WebNotificationFilter:int:int", "filter:offset:limit", "", "java.util.List"), 52);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo:boolean", "notification:moveTop", "", "void"), 196);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "int"), 202);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resetNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "void"), 208);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWebNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.Long", "notificationId", "", "org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity"), 315);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "id", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "boolean"), 96);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "long", "seconds", "", "boolean"), 107);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:long", "userId:seconds", "", "boolean"), 133);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 153);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hidePopover", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 164);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markAllRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "void"), 175);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnreadNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:java.lang.String:java.lang.String", "pluginId:activityId:userId", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 182);
    }
}

