/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import org.hibernate.engine.jdbc.internal.TypeInfo;
import org.hibernate.engine.jdbc.internal.TypeNullability;
import org.hibernate.engine.jdbc.internal.TypeSearchability;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.jboss.logging.Logger;

public class TypeInfoExtracter {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TypeInfoExtracter.class.getName());

    private TypeInfoExtracter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashSet<TypeInfo> extractTypeInfo(DatabaseMetaData metaData) {
        LinkedHashSet<TypeInfo> typeInfoSet = new LinkedHashSet<TypeInfo>();
        try {
            ResultSet resultSet = metaData.getTypeInfo();
            try {
                while (resultSet.next()) {
                    typeInfoSet.add(new TypeInfo(resultSet.getString("TYPE_NAME"), resultSet.getInt("DATA_TYPE"), TypeInfoExtracter.interpretCreateParams(resultSet.getString("CREATE_PARAMS")), resultSet.getBoolean("UNSIGNED_ATTRIBUTE"), resultSet.getInt("PRECISION"), resultSet.getShort("MINIMUM_SCALE"), resultSet.getShort("MAXIMUM_SCALE"), resultSet.getBoolean("FIXED_PREC_SCALE"), resultSet.getString("LITERAL_PREFIX"), resultSet.getString("LITERAL_SUFFIX"), resultSet.getBoolean("CASE_SENSITIVE"), TypeSearchability.interpret(resultSet.getShort("SEARCHABLE")), TypeNullability.interpret(resultSet.getShort("NULLABLE"))));
                }
            }
            catch (SQLException e) {
                LOG.unableToAccessTypeInfoResultSet(e.toString());
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.unableToReleaseTypeInfoResultSet();
                }
            }
        }
        catch (SQLException e) {
            LOG.unableToRetrieveTypeInfoResultSet(e.toString());
        }
        return typeInfoSet;
    }

    private static String[] interpretCreateParams(String value) {
        if (value == null || value.length() == 0) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return value.split(",");
    }
}

