/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.register;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.portal.webui.CaptchaValidator;
import org.exoplatform.portal.webui.register.UICaptcha;
import org.exoplatform.portal.webui.register.UIRegisterInputSet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class})})
@Serialized
public class UIRegisterEditMode
extends UIForm {
    public static final String USE_CAPTCHA = "useCaptcha";

    public UIRegisterEditMode() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        boolean useCaptcha = Boolean.parseBoolean(pref.getValue(USE_CAPTCHA, "true"));
        this.addUIFormInput(new UIFormCheckBoxInput(USE_CAPTCHA, USE_CAPTCHA, (Object)useCaptcha).setValue((Object)useCaptcha));
    }

    public static class SaveActionListener
    extends EventListener<UIRegisterEditMode> {
        public void execute(Event<UIRegisterEditMode> event) throws Exception {
            UIPortalApplication portalApp;
            UIRegisterEditMode uiForm = (UIRegisterEditMode)((Object)event.getSource());
            boolean useCaptcha = uiForm.getUIFormCheckBoxInput(UIRegisterEditMode.USE_CAPTCHA).isChecked();
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            pref.setValue(UIRegisterEditMode.USE_CAPTCHA, Boolean.toString(useCaptcha));
            pref.store();
            UIComponent registerPortlet = uiForm.getParent();
            UIRegisterInputSet registerInputSet = (UIRegisterInputSet)registerPortlet.findFirstComponentOfType(UIRegisterInputSet.class);
            if (useCaptcha) {
                if (!registerInputSet.getCaptchaInputAvailability()) {
                    registerInputSet.addUIFormInput((UIFormInput)new UICaptcha(UIRegisterInputSet.CAPTCHA, UIRegisterInputSet.CAPTCHA, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(CaptchaValidator.class, new Object[0]));
                    registerInputSet.setCaptchaInputAvailability(true);
                }
            } else if (registerInputSet.getCaptchaInputAvailability()) {
                registerInputSet.removeChildById(UIRegisterInputSet.CAPTCHA);
                registerInputSet.setCaptchaInputAvailability(false);
            }
            if ((portalApp = Util.getUIPortalApplication()).getModeState() == 0) {
                pcontext.setApplicationMode(PortletMode.VIEW);
            }
        }
    }
}

