/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class NamedExpression
extends IdentifierExpression {
    private Expression expression;
    private String name;

    public NamedExpression(HiddenTokenAwareTree underlyingStructure, String name, Expression expression) {
        super(underlyingStructure);
        this.name = name;
        this.expression = expression;
    }

    public NamedExpression(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.expression);
        result.addAll(super.getChilds());
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.NAMED_EXPRESSION;
    }

    @Override
    public NamedExpression clone() {
        NamedExpression result = (NamedExpression)super.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

