/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.EC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC3TrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    int samplerate;
    int bitrate;
    int frameSize;
    List<BitStreamInfo> entries = new LinkedList<BitStreamInfo>();
    private InputStream inputStream;
    private List<ByteBuffer> samples;
    List<TimeToSampleBox.Entry> stts = new LinkedList<TimeToSampleBox.Entry>();

    public EC3TrackImpl(InputStream fin) throws IOException {
        this.inputStream = fin;
        boolean done = false;
        while (!done) {
            BitStreamInfo bsi = this.readVariables();
            if (bsi == null) {
                throw new IOException();
            }
            int i = 0;
            while (i < this.entries.size()) {
                if (bsi.strmtyp != 1 && this.entries.get((int)i).substreamid == bsi.substreamid) {
                    done = true;
                }
                ++i;
            }
            if (done) continue;
            this.entries.add(bsi);
            this.inputStream.skip(bsi.frameSize);
        }
        for (BitStreamInfo bsi : this.entries) {
            this.inputStream.skip(-1 * bsi.frameSize);
        }
        if (this.entries.size() == 0) {
            throw new IOException();
        }
        this.samplerate = this.entries.get((int)0).samplerate;
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry("ec-3");
        audioSampleEntry.setChannelCount(2);
        audioSampleEntry.setSampleRate(this.samplerate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        EC3SpecificBox ec3 = new EC3SpecificBox();
        int[] deps = new int[this.entries.size()];
        int[] chan_locs = new int[this.entries.size()];
        for (BitStreamInfo bsi : this.entries) {
            if (bsi.strmtyp != 1) continue;
            int n = bsi.substreamid;
            deps[n] = deps[n] + 1;
            chan_locs[bsi.substreamid] = bsi.chanmap >> 6 & 0x100 | bsi.chanmap >> 5 & 0xFF;
        }
        for (BitStreamInfo bsi : this.entries) {
            if (bsi.strmtyp != 1) {
                EC3SpecificBox.Entry e = new EC3SpecificBox.Entry();
                e.fscod = bsi.fscod;
                e.bsid = bsi.bsid;
                e.bsmod = bsi.bsmod;
                e.acmod = bsi.acmod;
                e.lfeon = bsi.lfeon;
                e.reserved = 0;
                e.num_dep_sub = deps[bsi.substreamid];
                e.chan_loc = chan_locs[bsi.substreamid];
                e.reserved2 = 0;
                ec3.addEntry(e);
            }
            this.bitrate += bsi.bitrate;
            this.frameSize += bsi.frameSize;
        }
        ec3.setDataRate(this.bitrate / 1000);
        audioSampleEntry.addBox(ec3);
        this.sampleDescriptionBox.addBox(audioSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage("eng");
        this.trackMetaData.setTimescale(this.samplerate);
        this.samples = new LinkedList<ByteBuffer>();
        if (!this.readSamples()) {
            throw new IOException();
        }
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new SoundMediaHeaderBox();
    }

    private BitStreamInfo readVariables() throws IOException {
        int numblkscod;
        byte[] data = new byte[200];
        if (200 != this.inputStream.read(data, 0, 200)) {
            return null;
        }
        this.inputStream.skip(-200L);
        ByteBuffer bb = ByteBuffer.wrap(data);
        BitReaderBuffer brb = new BitReaderBuffer(bb);
        int syncword = brb.readBits(16);
        if (syncword != 2935) {
            return null;
        }
        BitStreamInfo entry = new BitStreamInfo();
        entry.strmtyp = brb.readBits(2);
        entry.substreamid = brb.readBits(3);
        int frmsiz = brb.readBits(11);
        entry.frameSize = 2 * (frmsiz + 1);
        entry.fscod = brb.readBits(2);
        int fscod2 = -1;
        if (entry.fscod == 3) {
            fscod2 = brb.readBits(2);
            numblkscod = 3;
        } else {
            numblkscod = brb.readBits(2);
        }
        int numberOfBlocksPerSyncFrame = 0;
        switch (numblkscod) {
            case 0: {
                numberOfBlocksPerSyncFrame = 1;
                break;
            }
            case 1: {
                numberOfBlocksPerSyncFrame = 2;
                break;
            }
            case 2: {
                numberOfBlocksPerSyncFrame = 3;
                break;
            }
            case 3: {
                numberOfBlocksPerSyncFrame = 6;
            }
        }
        entry.acmod = brb.readBits(3);
        entry.lfeon = brb.readBits(1);
        entry.bsid = brb.readBits(5);
        brb.readBits(5);
        if (1 == brb.readBits(1)) {
            brb.readBits(8);
        }
        if (entry.acmod == 0) {
            brb.readBits(5);
            if (1 == brb.readBits(1)) {
                brb.readBits(8);
            }
        }
        if (1 == entry.strmtyp && 1 == brb.readBits(1)) {
            entry.chanmap = brb.readBits(16);
        }
        if (1 == brb.readBits(1)) {
            if (entry.acmod > 2) {
                brb.readBits(2);
            }
            if (1 == (entry.acmod & 1) && entry.acmod > 2) {
                brb.readBits(3);
                brb.readBits(3);
            }
            if ((entry.acmod & 4) > 0) {
                brb.readBits(3);
                brb.readBits(3);
            }
            if (1 == entry.lfeon && 1 == brb.readBits(1)) {
                brb.readBits(5);
            }
            if (entry.strmtyp == 0) {
                int mixdef;
                if (1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (entry.acmod == 0 && 1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (1 == (mixdef = brb.readBits(2))) {
                    brb.readBits(5);
                } else if (2 == mixdef) {
                    brb.readBits(12);
                } else if (3 == mixdef) {
                    int mixdeflen = brb.readBits(5);
                    if (1 == brb.readBits(1)) {
                        brb.readBits(5);
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            if (1 == brb.readBits(1)) {
                                brb.readBits(4);
                            }
                            if (1 == brb.readBits(1)) {
                                brb.readBits(4);
                            }
                        }
                    }
                    if (1 == brb.readBits(1)) {
                        brb.readBits(5);
                        if (1 == brb.readBits(1)) {
                            brb.readBits(7);
                            if (1 == brb.readBits(1)) {
                                brb.readBits(8);
                            }
                        }
                    }
                    int i = 0;
                    while (i < mixdeflen + 2) {
                        brb.readBits(8);
                        ++i;
                    }
                    brb.byteSync();
                }
                if (entry.acmod < 2) {
                    if (1 == brb.readBits(1)) {
                        brb.readBits(14);
                    }
                    if (entry.acmod == 0 && 1 == brb.readBits(1)) {
                        brb.readBits(14);
                    }
                    if (1 == brb.readBits(1)) {
                        if (numblkscod == 0) {
                            brb.readBits(5);
                        } else {
                            int i = 0;
                            while (i < numberOfBlocksPerSyncFrame) {
                                if (1 == brb.readBits(1)) {
                                    brb.readBits(5);
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        }
        if (1 == brb.readBits(1)) {
            entry.bsmod = brb.readBits(3);
        }
        block6 : switch (entry.fscod) {
            case 0: {
                entry.samplerate = 48000;
                break;
            }
            case 1: {
                entry.samplerate = 44100;
                break;
            }
            case 2: {
                entry.samplerate = 32000;
                break;
            }
            case 3: {
                switch (fscod2) {
                    case 0: {
                        entry.samplerate = 24000;
                        break block6;
                    }
                    case 1: {
                        entry.samplerate = 22050;
                        break block6;
                    }
                    case 2: {
                        entry.samplerate = 16000;
                        break block6;
                    }
                    case 3: {
                        entry.samplerate = 0;
                    }
                }
            }
        }
        if (entry.samplerate == 0) {
            return null;
        }
        entry.bitrate = (int)((double)entry.samplerate / 1536.0 * (double)entry.frameSize * 8.0);
        return entry;
    }

    private boolean readSamples() throws IOException {
        int read = this.frameSize;
        boolean ret = false;
        while (this.frameSize == read) {
            ret = true;
            byte[] data = new byte[this.frameSize];
            read = this.inputStream.read(data);
            if (read != this.frameSize) continue;
            this.samples.add(ByteBuffer.wrap(data));
            this.stts.add(new TimeToSampleBox.Entry(1L, 1536L));
        }
        return ret;
    }

    public static class BitStreamInfo
    extends EC3SpecificBox.Entry {
        public int frameSize;
        public int substreamid;
        public int bitrate;
        public int samplerate;
        public int strmtyp;
        public int chanmap;
    }
}

