/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class CMAPEncodingEntry {
    private static final Log LOG = LogFactory.getLog(CMAPEncodingEntry.class);
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private Map<Integer, Integer> characterCodeToGlyphId = new HashMap<Integer, Integer>();

    public void initData(TTFDataStream data) throws IOException {
        this.platformId = data.readUnsignedShort();
        this.platformEncodingId = data.readUnsignedShort();
        this.subTableOffset = data.readUnsignedInt();
    }

    public void initSubtable(CMAPTable cmap, int numGlyphs, TTFDataStream data) throws IOException {
        data.seek(cmap.getOffset() + this.subTableOffset);
        int subtableFormat = data.readUnsignedShort();
        if (subtableFormat < 8) {
            long length = data.readUnsignedShort();
            long version = data.readUnsignedShort();
        } else {
            data.readUnsignedShort();
            long length = data.readUnsignedInt();
            long version = data.readUnsignedInt();
        }
        switch (subtableFormat) {
            case 0: {
                this.processSubtype0(data);
                break;
            }
            case 2: {
                this.processSubtype2(data, numGlyphs);
                break;
            }
            case 4: {
                this.processSubtype4(data, numGlyphs);
                break;
            }
            case 6: {
                this.processSubtype6(data, numGlyphs);
                break;
            }
            case 8: {
                this.processSubtype8(data, numGlyphs);
                break;
            }
            case 10: {
                this.processSubtype10(data, numGlyphs);
                break;
            }
            case 12: {
                this.processSubtype12(data, numGlyphs);
                break;
            }
            case 13: {
                this.processSubtype13(data, numGlyphs);
                break;
            }
            case 14: {
                this.processSubtype14(data, numGlyphs);
                break;
            }
            default: {
                throw new IOException("Unknown cmap format:" + subtableFormat);
            }
        }
    }

    protected void processSubtype8(TTFDataStream data, int numGlyphs) throws IOException {
        int[] is32 = data.readUnsignedByteArray(8192);
        long nbGroups = data.readUnsignedInt();
        if (nbGroups > 65536L) {
            throw new IOException("CMap ( Subtype8 ) is invalid");
        }
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i = 0L; i < nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode > endCode || 0L > firstCode) {
                throw new IOException("Range invalid");
            }
            for (long j = firstCode; j <= endCode; ++j) {
                int currentCharCode;
                if (j > Integer.MAX_VALUE) {
                    throw new IOException("[Sub Format 8] Invalid Character code");
                }
                if ((is32[(int)j / 8] & 1 << (int)j % 8) == 0) {
                    currentCharCode = (int)j;
                } else {
                    long LEAD_OFFSET = 55232L;
                    long lead = LEAD_OFFSET + (j >> 10);
                    long trail = 56320L + (j & 0x3FFL);
                    long SURROGATE_OFFSET = -56613888L;
                    long codepoint = (lead << 10) + trail + SURROGATE_OFFSET;
                    if (codepoint > Integer.MAX_VALUE) {
                        throw new IOException("[Sub Format 8] Invalid Character code");
                    }
                    currentCharCode = (int)codepoint;
                }
                long glyphIndex = startGlyph + (j - firstCode);
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = currentCharCode;
                this.characterCodeToGlyphId.put(currentCharCode, (int)glyphIndex);
            }
        }
    }

    protected void processSubtype10(TTFDataStream data, int numGlyphs) throws IOException {
        long startCode = data.readUnsignedInt();
        long numChars = data.readUnsignedInt();
        if (numChars > Integer.MAX_VALUE) {
            throw new IOException("Invalid number of Characters");
        }
        if (startCode < 0L || startCode > 0x10FFFFL || startCode + numChars > 0x10FFFFL || startCode + numChars >= 55296L && startCode + numChars <= 57343L) {
            throw new IOException("Invalid Characters codes");
        }
    }

    protected void processSubtype12(TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i = 0L; i < nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j = 0L; j <= endCode - firstCode; ++j) {
                if (firstCode + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                long glyphIndex = startGlyph + j;
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = (int)(firstCode + j);
                this.characterCodeToGlyphId.put((int)(firstCode + j), (int)glyphIndex);
            }
        }
    }

    protected void processSubtype13(TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        for (long i = 0L; i < nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long glyphId = data.readUnsignedInt();
            if (glyphId > (long)numGlyphs) {
                throw new IOException("CMap contains an invalid glyph index");
            }
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j = 0L; j <= endCode - firstCode; ++j) {
                if (firstCode + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                this.glyphIdToCharacterCode[(int)glyphId] = (int)(firstCode + j);
                this.characterCodeToGlyphId.put((int)(firstCode + j), (int)glyphId);
            }
        }
    }

    protected void processSubtype14(TTFDataStream data, int numGlyphs) throws IOException {
        throw new IOException("CMap subtype 14 not yet implemented");
    }

    protected void processSubtype6(TTFDataStream data, int numGlyphs) throws IOException {
        int firstCode = data.readUnsignedShort();
        int entryCount = data.readUnsignedShort();
        if (entryCount == 0) {
            return;
        }
        HashMap<Integer, Integer> tmpGlyphToChar = new HashMap<Integer, Integer>();
        int[] glyphIdArray = data.readUnsignedShortArray(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            tmpGlyphToChar.put(glyphIdArray[i], firstCode + i);
            this.characterCodeToGlyphId.put(firstCode + i, glyphIdArray[i]);
        }
        this.glyphIdToCharacterCode = new int[(Integer)Collections.max(tmpGlyphToChar.keySet()) + 1];
        for (Map.Entry entry : tmpGlyphToChar.entrySet()) {
            this.glyphIdToCharacterCode[((Integer)entry.getKey()).intValue()] = (Integer)entry.getValue();
        }
    }

    protected void processSubtype4(TTFDataStream data, int numGlyphs) throws IOException {
        int segCountX2 = data.readUnsignedShort();
        int segCount = segCountX2 / 2;
        int searchRange = data.readUnsignedShort();
        int entrySelector = data.readUnsignedShort();
        int rangeShift = data.readUnsignedShort();
        int[] endCount = data.readUnsignedShortArray(segCount);
        int reservedPad = data.readUnsignedShort();
        int[] startCount = data.readUnsignedShortArray(segCount);
        int[] idDelta = data.readUnsignedShortArray(segCount);
        int[] idRangeOffset = data.readUnsignedShortArray(segCount);
        HashMap<Integer, Integer> tmpGlyphToChar = new HashMap<Integer, Integer>();
        long currentPosition = data.getCurrentPosition();
        for (int i = 0; i < segCount; ++i) {
            int start = startCount[i];
            int end = endCount[i];
            int delta = idDelta[i];
            int rangeOffset = idRangeOffset[i];
            if (start == 65535 || end == 65535) continue;
            for (int j = start; j <= end; ++j) {
                if (rangeOffset == 0) {
                    int glyphid = (j + delta) % 65536;
                    tmpGlyphToChar.put(glyphid, j);
                    this.characterCodeToGlyphId.put(j, glyphid);
                    continue;
                }
                long glyphOffset = currentPosition + (long)((rangeOffset / 2 + (j - start) + (i - segCount)) * 2);
                data.seek(glyphOffset);
                int glyphIndex = data.readUnsignedShort();
                if (glyphIndex == 0) continue;
                glyphIndex += delta;
                if (tmpGlyphToChar.containsKey(glyphIndex %= 65536)) continue;
                tmpGlyphToChar.put(glyphIndex, j);
                this.characterCodeToGlyphId.put(j, glyphIndex);
            }
        }
        if (tmpGlyphToChar.isEmpty()) {
            LOG.warn((Object)"cmap format 4 subtable is empty");
            return;
        }
        this.glyphIdToCharacterCode = new int[(Integer)Collections.max(tmpGlyphToChar.keySet()) + 1];
        Arrays.fill(this.glyphIdToCharacterCode, 0);
        for (Map.Entry entry : tmpGlyphToChar.entrySet()) {
            this.glyphIdToCharacterCode[((Integer)entry.getKey()).intValue()] = (Integer)entry.getValue();
        }
    }

    protected void processSubtype2(TTFDataStream data, int numGlyphs) throws IOException {
        int[] subHeaderKeys = new int[256];
        int maxSubHeaderIndex = 0;
        for (int i = 0; i < 256; ++i) {
            subHeaderKeys[i] = data.readUnsignedShort();
            maxSubHeaderIndex = Math.max(maxSubHeaderIndex, subHeaderKeys[i] / 8);
        }
        SubHeader[] subHeaders = new SubHeader[maxSubHeaderIndex + 1];
        for (int i = 0; i <= maxSubHeaderIndex; ++i) {
            int firstCode = data.readUnsignedShort();
            int entryCount = data.readUnsignedShort();
            short idDelta = data.readSignedShort();
            int idRangeOffset = data.readUnsignedShort() - (maxSubHeaderIndex + 1 - i - 1) * 8 - 2;
            subHeaders[i] = new SubHeader(firstCode, entryCount, idDelta, idRangeOffset);
        }
        long startGlyphIndexOffset = data.getCurrentPosition();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (int i = 0; i <= maxSubHeaderIndex; ++i) {
            SubHeader sh = subHeaders[i];
            int firstCode = sh.getFirstCode();
            int idRangeOffset = sh.getIdRangeOffset();
            short idDelta = sh.getIdDelta();
            int entryCount = sh.getEntryCount();
            data.seek(startGlyphIndexOffset + (long)idRangeOffset);
            for (int j = 0; j < entryCount; ++j) {
                int charCode = i;
                charCode = (charCode << 8) + (firstCode + j);
                int p = data.readUnsignedShort();
                if (p > 0) {
                    p = (p + idDelta) % 65536;
                }
                this.glyphIdToCharacterCode[p] = charCode;
                this.characterCodeToGlyphId.put(charCode, p);
            }
        }
    }

    protected void processSubtype0(TTFDataStream data) throws IOException {
        byte[] glyphMapping = data.read(256);
        this.glyphIdToCharacterCode = new int[256];
        for (int i = 0; i < glyphMapping.length; ++i) {
            int glyphIndex = (glyphMapping[i] + 256) % 256;
            this.glyphIdToCharacterCode[glyphIndex] = i;
            this.characterCodeToGlyphId.put(i, glyphIndex);
        }
    }

    public int[] getGlyphIdToCharacterCode() {
        return this.glyphIdToCharacterCode;
    }

    public void setGlyphIdToCharacterCode(int[] glyphIdToCharacterCodeValue) {
        this.glyphIdToCharacterCode = glyphIdToCharacterCodeValue;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int platformEncodingIdValue) {
        this.platformEncodingId = platformEncodingIdValue;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformIdValue) {
        this.platformId = platformIdValue;
    }

    public int getGlyphId(int characterCode) {
        Integer glyphId = this.characterCodeToGlyphId.get(characterCode);
        return glyphId == null ? 0 : glyphId;
    }

    private class SubHeader {
        private final int firstCode;
        private final int entryCount;
        private final short idDelta;
        private final int idRangeOffset;

        private SubHeader(int firstCode, int entryCount, short idDelta, int idRangeOffset) {
            this.firstCode = firstCode;
            this.entryCount = entryCount;
            this.idDelta = idDelta;
            this.idRangeOffset = idRangeOffset;
        }

        private int getFirstCode() {
            return this.firstCode;
        }

        private int getEntryCount() {
            return this.entryCount;
        }

        private short getIdDelta() {
            return this.idDelta;
        }

        private int getIdRangeOffset() {
            return this.idRangeOffset;
        }
    }
}

