/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategoriesPlugins;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.registry.dao.ApplicationDAO;
import org.exoplatform.application.registry.dao.CategoryDAO;
import org.exoplatform.application.registry.entity.ApplicationEntity;
import org.exoplatform.application.registry.entity.CategoryEntity;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.mop.jdbc.dao.PermissionDAO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.MembershipEntry;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.mop.api.content.ContentType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.picocontainer.Startable;

public class JDBCApplicationRegistryService
implements ApplicationRegistryService,
Startable {
    private static final Log log = ExoLogger.getExoLogger(JDBCApplicationRegistryService.class);
    private CategoryDAO catDAO;
    private ApplicationDAO appDAO;
    private PermissionDAO permissionDAO;
    private String anyOfAdminGroup;
    private List<ApplicationCategoriesPlugins> plugins = new ArrayList<ApplicationCategoriesPlugins>();
    private static final String INTERNAL_PORTLET_TAG = "gatein_internal";
    private static final String REMOTE_CATEGORY_NAME = "remote";
    private static final String PRODUCER_NAME_META_INFO_KEY = "producer-name";
    public static final String PRODUCER_CATEGORY_NAME_SUFFIX = " Producer";

    public JDBCApplicationRegistryService(CategoryDAO catDAO, ApplicationDAO appDAO, PermissionDAO permissionDAO, UserACL userACL) {
        this.catDAO = catDAO;
        this.appDAO = appDAO;
        this.permissionDAO = permissionDAO;
        this.anyOfAdminGroup = new MembershipEntry(userACL.getAdminGroups()).toString();
    }

    public List<ApplicationCategory> getApplicationCategories(Comparator<ApplicationCategory> sortComparator, String accessUser, ApplicationType<?> ... appTypes) {
        ArrayList<ApplicationCategory> categories = new ArrayList<ApplicationCategory>();
        for (CategoryEntity catEntity : this.catDAO.findAll()) {
            ApplicationCategory category = this.buildCategory(catEntity, appTypes);
            categories.add(category);
        }
        if (sortComparator != null) {
            Collections.sort(categories, sortComparator);
        }
        return categories;
    }

    @Override
    public ApplicationCategory getApplicationCategory(String name) {
        CategoryEntity catEntity = this.catDAO.findByName(name);
        if (catEntity != null) {
            return this.buildCategory(catEntity, new ApplicationType[0]);
        }
        return null;
    }

    @Override
    public void save(ApplicationCategory category) {
        CategoryEntity catEntity = this.catDAO.findByName(category.getName());
        if ((catEntity = this.buildCatEntity(catEntity, category)).getId() == null) {
            this.catDAO.create(catEntity);
        } else {
            this.catDAO.update(catEntity);
        }
        this.permissionDAO.savePermissions(CategoryEntity.class.getName(), catEntity.getId(), PermissionEntity.TYPE.ACCESS, category.getAccessPermissions());
    }

    @Override
    public void remove(ApplicationCategory category) {
        LinkedList<Long> ids = new LinkedList<Long>();
        CategoryEntity catEntity = this.catDAO.findByName(category.getName());
        if (catEntity != null) {
            for (ApplicationEntity app : catEntity.getApplications()) {
                ids.add(app.getId());
            }
            ids.add(catEntity.getId());
            this.catDAO.delete(catEntity);
        }
        for (Long id : ids) {
            this.permissionDAO.deletePermissions(ApplicationEntity.class.getName(), id);
        }
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, Comparator<Application> sortComparator, ApplicationType<?> ... appTypes) {
        ArrayList<Application> apps = new ArrayList<Application>();
        CategoryEntity catEntity = this.catDAO.findByName(category.getName());
        if (catEntity != null) {
            category = this.buildCategory(catEntity, appTypes);
            apps.addAll(category.getApplications());
        }
        if (sortComparator != null) {
            Collections.sort(apps, sortComparator);
        }
        return apps;
    }

    @Override
    public List<Application> getAllApplications() throws Exception {
        ArrayList<Application> apps = new ArrayList<Application>();
        for (ApplicationEntity appEntity : this.appDAO.findAll()) {
            apps.add(this.buildApplication(appEntity));
        }
        return apps;
    }

    @Override
    public Application getApplication(String category, String name) {
        ApplicationEntity appEntity = this.appDAO.find(category, name);
        if (appEntity != null) {
            return this.buildApplication(appEntity);
        }
        return null;
    }

    @Override
    public void save(ApplicationCategory category, Application application) {
        this.save(category);
        CategoryEntity catEntity = this.catDAO.findByName(category.getName());
        ApplicationEntity appEntity = this.appDAO.find(category.getName(), application.getApplicationName());
        if (appEntity == null && application.getStorageId() != null) {
            appEntity = (ApplicationEntity)this.appDAO.find(Long.valueOf(Safe.parseLong((String)application.getStorageId())));
        }
        appEntity = this.buildAppEntity(appEntity, application);
        appEntity.setCategory(catEntity);
        catEntity.getApplications().add(appEntity);
        if (appEntity.getId() == null) {
            this.appDAO.create(appEntity);
        } else {
            this.appDAO.update(appEntity);
        }
        this.permissionDAO.savePermissions(ApplicationEntity.class.getName(), appEntity.getId(), PermissionEntity.TYPE.ACCESS, application.getAccessPermissions());
    }

    @Override
    public void update(Application application) {
        ApplicationEntity appEntity = (ApplicationEntity)this.appDAO.find(Long.valueOf(Safe.parseLong((String)application.getStorageId())));
        if (appEntity == null) {
            throw new IllegalStateException();
        }
        appEntity = this.buildAppEntity(appEntity, application);
        this.appDAO.update(appEntity);
    }

    @Override
    public void remove(Application app) {
        ApplicationEntity appEntity = (ApplicationEntity)this.appDAO.find(Long.valueOf(Safe.parseLong((String)app.getStorageId())));
        if (appEntity != null) {
            this.permissionDAO.deletePermissions(ApplicationEntity.class.getName(), appEntity.getId());
            this.appDAO.delete(appEntity);
        }
    }

    @Override
    public Collection<ApplicationCategory> detectPortletsFromWars() throws PortletInvokerException {
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        HashMap<String, ApplicationCategory> categoriesMap = new HashMap<String, ApplicationCategory>();
        for (Portlet portlet : portlets) {
            LocalizedString displayNameLS;
            PortletInfo info = portlet.getInfo();
            String categoryName = info.getApplicationName().trim();
            String portletName = info.getName();
            String contentId = categoryName + "/" + portletName;
            ApplicationCategory category = (ApplicationCategory)categoriesMap.get(categoryName);
            if (category == null) {
                category = new ApplicationCategory();
                category.setName(categoryName);
                category.setDisplayName(categoryName);
                category.setApplications(new ArrayList<Application>());
                categoriesMap.put(categoryName, category);
            }
            Application application = new Application();
            application.setApplicationName(portletName);
            application.setCategoryName(categoryName);
            application.setType(ApplicationType.PORTLET);
            application.setContentId(contentId);
            application.setId(contentId);
            LocalizedString descriptionLS = info.getMeta().getMetaValue("description");
            if (descriptionLS != null) {
                application.setDescription(this.getLocalizedStringValue(descriptionLS, portletName));
            }
            if ((displayNameLS = portlet.getInfo().getMeta().getMetaValue("display-name")) != null) {
                application.setDisplayName(this.getLocalizedStringValue(displayNameLS, portletName));
            }
            category.getApplications().add(application);
        }
        return categoriesMap.values();
    }

    @Override
    public void importAllPortlets() throws Exception {
        log.info((Object)"About to import portlets in application registry");
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        block0: for (Portlet portlet : portlets) {
            boolean remote;
            String keywords;
            if (portlet.isRemote()) continue;
            PortletInfo info = portlet.getInfo();
            String portletApplicationName = info.getApplicationName();
            String portletName = portlet.getContext().getId();
            portletApplicationName = portletApplicationName.replace('/', '_');
            portletName = portletName.replace('/', '_');
            MetaInfo metaInfo = portlet.getInfo().getMeta();
            LocalizedString keywordsLS = metaInfo.getMetaValue("keywords");
            HashSet<String> categoryNames = new HashSet<String>();
            if (keywordsLS != null && (keywords = keywordsLS.getDefaultString()) != null && keywords.length() != 0) {
                for (String categoryName : keywords.split(",")) {
                    if (INTERNAL_PORTLET_TAG.equalsIgnoreCase(categoryName = categoryName.trim())) {
                        log.debug((Object)("Skipping portlet (" + portletApplicationName + "," + portletName + ") + tagged as internal"));
                        continue block0;
                    }
                    categoryNames.add(categoryName);
                }
            }
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add(this.anyOfAdminGroup);
            if (categoryNames.isEmpty()) {
                categoryNames.add(portletApplicationName.trim());
            }
            if (remote = portlet.isRemote()) {
                categoryNames.add(REMOTE_CATEGORY_NAME);
                LocalizedString producerNameLS = metaInfo.getMetaValue(PRODUCER_NAME_META_INFO_KEY);
                if (producerNameLS != null) {
                    categoryNames.add(producerNameLS.getDefaultString() + PRODUCER_CATEGORY_NAME_SUFFIX);
                }
            }
            log.info((Object)("Importing portlet (" + portletApplicationName + "," + portletName + ") in categories " + categoryNames));
            for (String categoryName : categoryNames) {
                String contentId;
                ApplicationType appType;
                ApplicationEntity app;
                CategoryEntity category = this.catDAO.findByName(categoryName);
                if (category == null) {
                    category = new CategoryEntity();
                    category.setName(categoryName);
                    category.setDisplayName(categoryName);
                    this.catDAO.create(category);
                    this.permissionDAO.savePermissions(CategoryEntity.class.getName(), category.getId(), PermissionEntity.TYPE.ACCESS, permissions);
                }
                if ((app = this.appDAO.find(categoryName, portletName)) != null) continue;
                LocalizedString descriptionLS = metaInfo.getMetaValue("description");
                LocalizedString displayNameLS = metaInfo.getMetaValue("display-name");
                String displayName = this.getLocalizedStringValue(displayNameLS, portletName);
                if (remote) {
                    appType = ApplicationType.PORTLET;
                    contentId = portlet.getContext().getId();
                    displayName = displayName + " (remote)";
                } else {
                    appType = ApplicationType.PORTLET;
                    contentId = info.getApplicationName() + "/" + info.getName();
                }
                List<Application> applications = this.buildCategory(category, new ApplicationType[0]).getApplications();
                boolean isExist = false;
                for (Application application : applications) {
                    if (!application.getContentId().equals(contentId)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                app = new ApplicationEntity();
                app.setApplicationName(portletName);
                app.setCategory(category);
                app.setContentId(contentId);
                app.setType(appType.getName());
                app.setDisplayName(displayName);
                app.setDescription(this.getLocalizedStringValue(descriptionLS, portletName));
                this.appDAO.create(app);
                this.permissionDAO.savePermissions(ApplicationEntity.class.getName(), app.getId(), PermissionEntity.TYPE.ACCESS, permissions);
            }
        }
    }

    private ApplicationCategory buildCategory(CategoryEntity catEntity, ApplicationType<?> ... appTypes) {
        ApplicationCategory category = new ApplicationCategory();
        category.setName(catEntity.getName());
        category.setDisplayName(catEntity.getDisplayName());
        category.setDescription(catEntity.getDescription());
        List<String> access = this.buildPermission(this.permissionDAO.getPermissions(CategoryEntity.class.getName(), catEntity.getId(), PermissionEntity.TYPE.ACCESS));
        category.setAccessPermissions(access);
        category.setCreatedDate(new Date(catEntity.getCreatedDate()));
        category.setModifiedDate(new Date(catEntity.getModifiedDate()));
        for (ApplicationEntity appEntity : catEntity.getApplications()) {
            Application application = this.buildApplication(appEntity);
            if (!this.isApplicationType(application, appTypes)) continue;
            category.getApplications().add(application);
        }
        return category;
    }

    private List<String> buildPermission(List<PermissionEntity> permissions) {
        ArrayList<String> results = new ArrayList<String>();
        if (permissions != null) {
            for (PermissionEntity permission : permissions) {
                results.add(permission.getPermission());
            }
        }
        return results;
    }

    private boolean isApplicationType(Application app, ApplicationType<?> ... appTypes) {
        if (appTypes == null || appTypes.length == 0) {
            return true;
        }
        for (ApplicationType<?> appType : appTypes) {
            if (!appType.equals(app.getType())) continue;
            return true;
        }
        return false;
    }

    private Application buildApplication(ApplicationEntity appEntity) {
        ApplicationType applicationType = ApplicationType.getType((String)appEntity.getType());
        Application application = new Application();
        application.setId(appEntity.getCategory().getName() + "/" + appEntity.getApplicationName());
        application.setCategoryName(appEntity.getCategory().getName());
        application.setType(applicationType);
        application.setApplicationName(appEntity.getApplicationName());
        application.setIconURL(JDBCApplicationRegistryService.getApplicationIconURL(appEntity));
        application.setDisplayName(appEntity.getDisplayName());
        application.setDescription(appEntity.getDescription());
        List<String> access = this.buildPermission(this.permissionDAO.getPermissions(ApplicationEntity.class.getName(), appEntity.getId(), PermissionEntity.TYPE.ACCESS));
        application.setAccessPermissions(new ArrayList<String>(access));
        application.setCreatedDate(new Date(appEntity.getCreatedDate()));
        application.setModifiedDate(new Date(appEntity.getModifiedDate()));
        application.setStorageId(String.valueOf(appEntity.getId()));
        application.setContentId(appEntity.getContentId());
        return application;
    }

    private static String getApplicationIconURL(ApplicationEntity appEntity) {
        String[] chunks;
        ApplicationType applicationType = ApplicationType.getType((String)appEntity.getType());
        ContentType type = applicationType.getContentType();
        String contentId = appEntity.getContentId();
        if (type == org.exoplatform.portal.pom.spi.portlet.Portlet.CONTENT_TYPE && (chunks = contentId.split("/")).length == 2) {
            return "/" + chunks[0] + "/skin/DefaultSkin/portletIcons/" + chunks[1] + ".png";
        }
        return null;
    }

    private CategoryEntity buildCatEntity(CategoryEntity catEntity, ApplicationCategory category) {
        if (catEntity == null) {
            catEntity = new CategoryEntity();
        }
        if (category.getCreatedDate() != null) {
            catEntity.setCreatedDate(category.getCreatedDate().getTime());
        }
        catEntity.setDescription(category.getDescription());
        catEntity.setDisplayName(category.getDisplayName());
        if (category.getModifiedDate() != null) {
            catEntity.setModifiedDate(category.getModifiedDate().getTime());
        }
        catEntity.setName(category.getName());
        return catEntity;
    }

    private ApplicationEntity buildAppEntity(ApplicationEntity appEntity, Application application) {
        if (appEntity == null) {
            appEntity = new ApplicationEntity();
        }
        appEntity.setApplicationName(application.getApplicationName());
        appEntity.setContentId(application.getContentId());
        if (application.getCreatedDate() != null) {
            appEntity.setCreatedDate(application.getCreatedDate().getTime());
        }
        appEntity.setDescription(application.getDescription());
        appEntity.setDisplayName(application.getDisplayName());
        if (application.getType() != null) {
            appEntity.setType(application.getType().getName());
        } else {
            appEntity.setType(ApplicationType.PORTLET.getName());
        }
        if (application.getModifiedDate() != null) {
            appEntity.setModifiedDate(application.getModifiedDate().getTime());
        }
        return appEntity;
    }

    private String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.plugins != null) {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            try {
                boolean firstStartup = this.getApplicationCategories().isEmpty();
                for (ApplicationCategoriesPlugins plugin : this.plugins) {
                    plugin.run(firstStartup);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void stop() {
    }

    @Override
    public Application getApplication(String id) throws Exception {
        String[] fragments = id.split("/");
        if (fragments.length < 2) {
            throw new Exception("Invalid Application Id: [" + id + "]");
        }
        String category = fragments[0];
        String applicationName = fragments[1];
        if (fragments.length == 3 && applicationName.length() == 0) {
            applicationName = "/" + fragments[2];
        }
        return this.getApplication(category, applicationName);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.getApplicationCategories(null);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(Comparator<ApplicationCategory> sortComparator) throws Exception {
        return this.getApplicationCategories(sortComparator, null, new ApplicationType[0]);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(String appName, ApplicationType appType, Comparator<ApplicationCategory> sortComparator) {
        ArrayList<ApplicationCategory> categories = new ArrayList<ApplicationCategory>();
        block0: for (ApplicationCategory category : this.getApplicationCategories(sortComparator, null, appType)) {
            if (appName != null) {
                for (Application application : category.getApplications()) {
                    if (!appName.equals(application.getApplicationName())) continue;
                    categories.add(category);
                    continue block0;
                }
                continue;
            }
            categories.add(category);
        }
        return categories;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(String accessUser, ApplicationType<?> ... appTypes) throws Exception {
        return this.getApplicationCategories(null, accessUser, appTypes);
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, ApplicationType<?> ... appTypes) throws Exception {
        return this.getApplications(category, (Comparator<Application>)null, appTypes);
    }

    @Override
    public void initListener(ComponentPlugin plugin) {
        if (plugin instanceof ApplicationCategoriesPlugins) {
            List<ApplicationCategory> categories;
            ApplicationCategoriesPlugins categoriesPlugin = (ApplicationCategoriesPlugins)plugin;
            if (categoriesPlugin.isMerge() && (categories = categoriesPlugin.getCategories()) != null && !categories.isEmpty()) {
                Iterator<ApplicationCategory> categoriesIterator = categories.iterator();
                while (categoriesIterator.hasNext()) {
                    ApplicationCategory category = categoriesIterator.next();
                    ApplicationCategory existingCategory = this.plugins.stream().map(ApplicationCategoriesPlugins::getCategories).flatMap(Collection::stream).filter(configuredCategory -> configuredCategory.getName().equals(category.getName())).findFirst().orElse(null);
                    if (existingCategory == null) continue;
                    existingCategory.getApplications().addAll(category.getApplications());
                    categoriesIterator.remove();
                }
            }
            this.plugins.add(categoriesPlugin);
        }
    }
}

