/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.grib.grib2.ParameterTable;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.iosp.bufr.tables.BufrTables;

public class RuntimeConfigParser {
    public static void read(InputStream is, StringBuilder errlog) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        RuntimeConfigParser.read(doc.getRootElement(), errlog);
    }

    public static void read(Element root, StringBuilder errlog) {
        List children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String className;
            Element elem = (Element)children.get(i);
            if (elem.getName().equals("ioServiceProvider")) {
                String className2 = elem.getAttributeValue("class");
                try {
                    NetcdfFile.registerIOProvider(className2);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className2 + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("IOServiceProvider " + className2 + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordSysBuilder")) {
                String conventionName = elem.getAttributeValue("convention");
                className = elem.getAttributeValue("class");
                try {
                    CoordSysBuilder.registerConvention(conventionName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordSysBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordTransBuilder")) {
                String transformName = elem.getAttributeValue("name");
                className = elem.getAttributeValue("class");
                try {
                    CoordTransBuilder.registerTransform(transformName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordTransBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("typedDatasetFactory")) {
                String typeName = elem.getAttributeValue("datatype");
                className = elem.getAttributeValue("class");
                FeatureType datatype = FeatureType.valueOf(typeName.toUpperCase());
                if (null == datatype) {
                    errlog.append("TypedDatasetFactory " + className + " unknown datatype= " + typeName + "\n");
                    continue;
                }
                try {
                    TypedDatasetFactory.registerFactory(datatype, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("TypedDatasetFactory " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("table")) {
                String type = elem.getAttributeValue("type");
                String filename = elem.getAttributeValue("filename");
                if (type == null || filename == null) {
                    errlog.append("table element must have both type and filename attributes\n");
                    continue;
                }
                try {
                    if (type.equalsIgnoreCase("GRIB1")) {
                        GribPDSParamTable.addParameterUserLookup((String)filename);
                        continue;
                    }
                    if (type.equalsIgnoreCase("GRIB2")) {
                        ParameterTable.addParametersUser((String)filename);
                        continue;
                    }
                    errlog.append("Unknown table type " + type + "\n");
                }
                catch (Exception e) {
                    errlog.append("table read failed on  " + filename + " = " + e.getMessage() + "\n");
                }
                continue;
            }
            if (!elem.getName().equals("bufrtable")) continue;
            String filename = elem.getAttributeValue("filename");
            try {
                BufrTables.addLookupFile(filename);
                continue;
            }
            catch (Exception e) {
                errlog.append("bufrtable read failed on  " + filename + " = " + e.getMessage() + "\n");
            }
        }
    }
}

