/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class FilterDisabledLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(FilterDisabledLoginModule.class);
    private static Method getContextMethod;
    public static final String DISABLED_USER_NAME = "_disabledUserName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean login() throws LoginException {
        log.debug((Object)"In login of FilterDisabledLoginModule.");
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username")};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            if (username != null) {
                OrganizationService service = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
                try {
                    this.begin(service);
                    UserHandler uHandler = service.getUserHandler();
                    User user = uHandler.findUserByName(username, UserStatus.ANY);
                    if (user == null) {
                        log.debug("user {0} doesn't exists. FilterDisabledLoginModule will be ignored.", new Object[]{username});
                        return true;
                    }
                    if (user.isEnabled()) return true;
                    HttpServletRequest request = this.getCurrentHttpServletRequest();
                    if (request == null) throw new LoginException("Can't authenticate. user " + username + " is disabled");
                    request.setAttribute(DISABLED_USER_NAME, (Object)username);
                    throw new LoginException("Can't authenticate. user " + username + " is disabled");
                }
                finally {
                    this.end(service);
                }
            } else {
                log.debug((Object)"No username has been committed. FilterDisabledLoginModule will be ignored.");
            }
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            throw new LoginException(e.getMessage());
        }
    }

    protected HttpServletRequest getCurrentHttpServletRequest() {
        HttpServletRequest request = null;
        if (getContextMethod != null) {
            try {
                request = (HttpServletRequest)getContextMethod.invoke(null, "javax.servlet.http.HttpServletRequest");
            }
            catch (Throwable e) {
                log.error((Object)"LoginModule error. Turn off session credentials checking with proper configuration option of LoginModule set to false");
                log.error((Object)this, e);
            }
        } else {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.gatein.sso.agent.tomcat.ServletAccess");
                Method getRequestMethod = clazz.getDeclaredMethod("getRequest", new Class[0]);
                request = (HttpServletRequest)getRequestMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception when trying to obtain HttpServletRequest from ServletAccess thread-local", (Throwable)e);
            }
        }
        log.trace("Returning HttpServletRequest {0}", new Object[]{request});
        return request;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    private void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    private void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }

    static {
        try {
            Class<?> policyContextClass = Thread.currentThread().getContextClassLoader().loadClass("javax.security.jacc.PolicyContext");
            getContextMethod = policyContextClass.getDeclaredMethod("getContext", String.class);
        }
        catch (ClassNotFoundException ignore) {
            log.debug((Object)"JACC not found ignoring it", (Throwable)ignore);
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain JACC get context method", (Throwable)e);
        }
    }
}

