/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;

public class SpaceFilterKey
implements CacheKey {
    private static final long serialVersionUID = 2363449672896832814L;
    private String userId;
    private char firstCharacterOfSpaceName;
    private String spaceNameSearchCondition;
    private String appId;
    private SpaceType type;
    private Sorting sorting;

    public SpaceFilterKey(String userId, SpaceFilter filter, SpaceType type) {
        this.userId = userId;
        if (filter != null) {
            this.firstCharacterOfSpaceName = filter.getFirstCharacterOfSpaceName();
            this.spaceNameSearchCondition = filter.getSpaceNameSearchCondition();
            this.sorting = filter.getSorting();
            this.appId = filter.getAppId();
        }
        this.type = type;
    }

    public String getUserId() {
        return this.userId;
    }

    public char getFirstCharacterOfSpaceName() {
        return this.firstCharacterOfSpaceName;
    }

    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    public String getAppId() {
        return this.appId;
    }

    public SpaceType getType() {
        return this.type;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpaceFilterKey)) {
            return false;
        }
        SpaceFilterKey that = (SpaceFilterKey)o;
        if (this.appId != that.appId) {
            return false;
        }
        if (this.firstCharacterOfSpaceName != that.firstCharacterOfSpaceName) {
            return false;
        }
        if (this.sorting != null ? !this.sorting.equals(that.sorting) : that.sorting != null) {
            return false;
        }
        if (this.spaceNameSearchCondition != null ? !this.spaceNameSearchCondition.equals(that.spaceNameSearchCondition) : that.spaceNameSearchCondition != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(that.userId) : that.userId != null);
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + this.firstCharacterOfSpaceName;
        result = 31 * result + (this.spaceNameSearchCondition != null ? this.spaceNameSearchCondition.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.sorting != null ? this.sorting.hashCode() : 0);
        return result;
    }
}

