/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class VerticalTransformSubset
extends VerticalTransformImpl {
    private VerticalTransform original;
    private Range t_range;
    private List<Range> subsetList = new ArrayList<Range>();

    public VerticalTransformSubset(VerticalTransform original, Range t_range, Range z_range, Range y_range, Range x_range) {
        super(null);
        this.original = original;
        this.t_range = t_range;
        this.subsetList.add(z_range);
        this.subsetList.add(y_range);
        this.subsetList.add(x_range);
        this.units = original.getUnitString();
    }

    public ArrayDouble.D3 getCoordinateArray(int subsetIndex) throws IOException, InvalidRangeException {
        int orgIndex = subsetIndex;
        if (this.isTimeDependent() && this.t_range != null) {
            orgIndex = this.t_range.element(subsetIndex);
        }
        ArrayDouble.D3 data = this.original.getCoordinateArray(orgIndex);
        return (ArrayDouble.D3)data.sectionNoReduce(this.subsetList);
    }

    public boolean isTimeDependent() {
        return this.original.isTimeDependent();
    }
}

