/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application.metamodel;

import java.util.Map;
import javax.tools.FileObject;
import juzu.impl.common.JSON;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.MethodInvocationResolver;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateContainerMetaModel;

public class ApplicationMetaModel
extends MetaModel<ApplicationMetaModelPlugin, ApplicationMetaModel>
implements MethodInvocationResolver {
    public static final MessageCode CANNOT_WRITE_APPLICATION_CONFIG = new MessageCode("CANNOT_WRITE_APPLICATION_CONFIG", "The application %1$s configuration cannot be written");
    public static final MessageCode CANNOT_WRITE_CONFIG = new MessageCode("CANNOT_WRITE_CONFIG", "The configuration cannot be written");
    final ElementHandle.Package handle;
    public ModuleMetaModel model;
    boolean modified;
    final String baseName;

    ApplicationMetaModel(ElementHandle.Package handle, String baseName) {
        if (baseName == null) {
            String s = handle.getPackageName().toString();
            int index = s.lastIndexOf(46);
            baseName = Character.toUpperCase(s.charAt(index + 1)) + s.substring(index + 2);
        }
        this.handle = handle;
        this.modified = false;
        this.baseName = baseName;
    }

    public Name getName() {
        return this.handle.getPackageName();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ElementHandle.Package getHandle() {
        return this.handle;
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        MethodInvocation method = null;
        for (MetaModelObject child : this.getChildren()) {
            MethodInvocationResolver childResolver;
            MethodInvocation next;
            if (!(child instanceof MethodInvocationResolver) || (next = (childResolver = (MethodInvocationResolver)((Object)child)).resolveMethodInvocation(typeName, methodName, parameterMap)) == null) continue;
            if (method != null) {
                throw new UnsupportedOperationException("handle me gracefully");
            }
            method = next;
        }
        return method;
    }

    public FileObject resolveResource(Path.Absolute path) throws NullPointerException, IllegalArgumentException {
        return this.model.processingContext.resolveResourceFromSourcePath(this.handle, path);
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("handle", this.handle);
        json.set("qn", this.handle.getPackageName().toString());
        json.map("templates", this.getChild(TemplateContainerMetaModel.KEY));
        json.map("controllers", this.getChild(ControllersMetaModel.KEY));
        return json;
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ModuleMetaModel) {
            this.model = (ModuleMetaModel)parent;
            this.model.queue(MetaModelEvent.createAdded(this));
        }
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        if (parent instanceof ModuleMetaModel) {
            ModuleMetaModel applications = (ModuleMetaModel)parent;
            applications.queue(MetaModelEvent.createRemoved(this));
            this.model = null;
        }
    }
}

