/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;

public class TestWriteBoundaries
extends TestCase {
    public static byte[] getBytes(int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = IOUtils.fromInt((int)(i % 256));
        }
        return b;
    }

    public void testMix() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile ogg = new OggFile((OutputStream)baos);
        OggPacketWriter w = ogg.getPacketWriter(1193046);
        OggPacket p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, false);
        p = new OggPacket(new byte[]{10, 11, 12, 13, 14, 15});
        w.bufferPacket(p, true);
        p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, false);
        p = new OggPacket(TestWriteBoundaries.getBytes(131072));
        w.bufferPacket(p, false);
        p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, false);
        w.close();
        ogg = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = ogg.getPacketReader();
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)0, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)0, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)1, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)3, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)131072, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)3, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals(null, (Object)p);
    }

    public void testWriteBigPackets() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile ogg = new OggFile((OutputStream)baos);
        OggPacketWriter w = ogg.getPacketWriter(1193046);
        OggPacket p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, true);
        p = new OggPacket(TestWriteBoundaries.getBytes(131072));
        w.bufferPacket(p, true);
        p = new OggPacket(TestWriteBoundaries.getBytes(144077));
        w.bufferPacket(p, false);
        p = new OggPacket(TestWriteBoundaries.getBytes(161077));
        w.bufferPacket(p, false);
        p = new OggPacket(TestWriteBoundaries.getBytes(231079));
        w.bufferPacket(p, false);
        p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, true);
        p = new OggPacket(new byte[]{0, 1, 2, 3, 4, 5});
        w.bufferPacket(p, false);
        w.close();
        ogg = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = ogg.getPacketReader();
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)0, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)3, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)131072, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)6, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)144077, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)8, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)161077, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)12, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)231079, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)12, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals((int)13, (int)p.getSequenceNumber());
        TestWriteBoundaries.assertEquals((int)6, (int)p.getData().length);
        p = r.getNextPacket();
        TestWriteBoundaries.assertEquals(null, (Object)p);
    }
}

