/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.webui.exception.MessageException;

public class ExternalUsersListenerImpl
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(ExternalUsersListenerImpl.class);
    private static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";
    private IdentityManager identityManager;

    public void postSave(Membership m, boolean isNew) {
        Identity userIdentity;
        Profile profile;
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP) && (profile = (userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", m.getUserName())).getProfile()) != null) {
            profile.setProperty("external", String.valueOf(true));
            try {
                this.getIdentityManager().updateProfile(profile, true);
            }
            catch (MessageException e) {
                LOG.error("Error while saving the external property for user profile {}", new Object[]{m.getUserName(), e});
            }
        }
    }

    public void postDelete(Membership m) {
        Identity userIdentity;
        Profile profile;
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP) && (profile = (userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", m.getUserName())).getProfile()) != null) {
            profile.setProperty("external", String.valueOf(false));
            try {
                this.getIdentityManager().updateProfile(profile, true);
            }
            catch (MessageException e) {
                LOG.error("Error while saving the external property for user profile {}", new Object[]{m.getUserName(), e});
            }
        }
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return this.identityManager;
    }
}

