/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.jaas;

import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;

public class OAuthLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(OAuthLoginModule.class);
    private static Method getContextMethod;

    protected Log getLogger() {
        return log;
    }

    public boolean login() throws LoginException {
        try {
            ExoContainer container = this.getContainer();
            OAuthProviderTypeRegistry oauthRegistry = (OAuthProviderTypeRegistry)container.getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
            if (!oauthRegistry.isOAuthEnabled()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"OAuth is disabled. Ignoring this login module");
                }
                return false;
            }
            HttpServletRequest servletRequest = this.getCurrentHttpServletRequest();
            if (servletRequest == null) {
                log.debug((Object)"HttpServletRequest is null. OAuthLoginModule will be ignored.");
                return false;
            }
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)container.getComponentInstanceOfType(AuthenticationRegistry.class);
            User portalUser = (User)authRegistry.getAttributeOfClient(servletRequest, "_authenticatedPortalUserForJaas");
            if (portalUser == null) {
                log.debug((Object)"OAuthLogin Failed. Credential Not Found!!");
                return false;
            }
            authRegistry.removeAttributeOfClient(servletRequest, "_authenticatedPortalUserForJaas");
            Callback[] callbacks = new Callback[]{new NameCallback("Username")};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            if (username.equals(portalUser.getUserName())) {
                this.establishSecurityContext(container, username);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Successfully established security context for user " + username));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exception in login module", (Throwable)e);
            }
            throw new LoginException("OAuth login failed due to exception: " + e.getClass() + ": " + e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected void establishSecurityContext(ExoContainer container, String username) throws Exception {
        Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        if (authenticator == null) {
            throw new LoginException("No Authenticator component found, check your configuration");
        }
        Identity identity = authenticator.createIdentity(username);
        this.sharedState.put("exo.security.identity", identity);
        this.sharedState.put("javax.security.auth.login.name", username);
        this.subject.getPublicCredentials().add(new UsernameCredential(username));
    }

    protected HttpServletRequest getCurrentHttpServletRequest() {
        HttpServletRequest request = null;
        if (getContextMethod != null) {
            try {
                request = (HttpServletRequest)getContextMethod.invoke(null, "javax.servlet.http.HttpServletRequest");
            }
            catch (Throwable e) {
                log.error((Object)"LoginModule error. Turn off session credentials checking with proper configuration option of LoginModule set to false");
                log.error((Object)this, e);
            }
        } else {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.gatein.sso.agent.tomcat.ServletAccess");
                Method getRequestMethod = clazz.getDeclaredMethod("getRequest", new Class[0]);
                request = (HttpServletRequest)getRequestMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception when trying to obtain HttpServletRequest from ServletAccess thread-local", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning HttpServletRequest " + request));
        }
        return request;
    }

    static {
        try {
            Class<?> policyContextClass = Thread.currentThread().getContextClassLoader().loadClass("javax.security.jacc.PolicyContext");
            getContextMethod = policyContextClass.getDeclaredMethod("getContext", String.class);
        }
        catch (ClassNotFoundException ignore) {
            log.debug((Object)"JACC not found ignoring it", (Throwable)ignore);
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain JACC get context method", (Throwable)e);
        }
    }
}

