/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Tuple;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.XSpaceFilter;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceExternalInvitationDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.query.SpaceQueryBuilder;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceExternalInvitationEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class RDBMSSpaceStorageImpl
implements SpaceStorage {
    private static final Log LOG;
    private static final int BATCH_SIZE = 100;
    private SpaceDAO spaceDAO;
    private SpaceMemberDAO spaceMemberDAO;
    private IdentityDAO identityDAO;
    private IdentityStorage identityStorage;
    private ActivityDAO activityDAO;
    private SpaceExternalInvitationDAO spaceExternalInvitationDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public RDBMSSpaceStorageImpl(SpaceDAO spaceDAO, SpaceMemberDAO spaceMemberDAO, RDBMSIdentityStorageImpl identityStorage, IdentityDAO identityDAO, ActivityDAO activityDAO, SpaceExternalInvitationDAO spaceExternalInvitationDAO) {
        this.spaceDAO = spaceDAO;
        this.identityStorage = identityStorage;
        this.spaceMemberDAO = spaceMemberDAO;
        this.identityDAO = identityDAO;
        this.activityDAO = activityDAO;
        this.spaceExternalInvitationDAO = spaceExternalInvitationDAO;
    }

    @ExoTransactional
    public void deleteSpace(String id) throws SpaceStorageException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        RDBMSSpaceStorageImpl$AjcClosure1 rDBMSSpaceStorageImpl$AjcClosure1 = new RDBMSSpaceStorageImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSSpaceStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        return this.getAccessibleSpaces(userId, 0L, -1L);
    }

    public List<Space> getAccessibleSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.MEMBER), spaceFilter, offset, limit);
    }

    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.MEMBER), spaceFilter);
    }

    public int getAccessibleSpacesCount(String userId) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilterCount(userId, null);
    }

    public List<Space> getAllSpaces() throws SpaceStorageException {
        return this.getSpaces(0L, -1L);
    }

    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        return this.getSpacesCount(null, null, spaceFilter);
    }

    public int getAllSpacesCount() throws SpaceStorageException {
        return this.getAllSpacesByFilterCount(null);
    }

    public List<Space> getEditableSpaces(String userId) throws SpaceStorageException {
        return this.getEditableSpaces(userId, 0L, -1L);
    }

    public List<Space> getEditableSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getEditableSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getEditableSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter, offset, limit);
    }

    public int getEditableSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter);
    }

    public int getEditableSpacesCount(String userId) throws SpaceStorageException {
        return this.getEditableSpacesByFilterCount(userId, null);
    }

    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        return this.getInvitedSpaces(userId, 0L, -1L);
    }

    public List<Space> getInvitedSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getInvitedSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.INVITED), spaceFilter, offset, limit);
    }

    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.INVITED), spaceFilter);
    }

    public int getInvitedSpacesCount(String userId) throws SpaceStorageException {
        return this.getInvitedSpacesByFilterCount(userId, null);
    }

    public List<Space> getLastAccessedSpace(SpaceFilter spaceFilter, int offset, int limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setLastAccess(true);
        return this.getMemberSpacesByFilter(spaceFilter.getRemoteId(), xFilter, offset, limit);
    }

    public int getLastAccessedSpaceCount(SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(spaceFilter.getRemoteId(), spaceFilter);
    }

    public List<Space> getLastSpaces(int limit) {
        List<SpaceEntity> entities = this.spaceDAO.getLastSpaces(limit);
        return this.buildList(entities);
    }

    public List<Space> getManagerSpaces(String userId, long offset, long limit) {
        return this.getManagerSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getManagerSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter, offset, limit);
    }

    public int getManagerSpacesCount(String userId) {
        return this.getManagerSpacesByFilterCount(userId, null);
    }

    public int getManagerSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter);
    }

    public List<String> getMemberSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        Identity identity = this.identityStorage.findIdentityById(identityId);
        List<Long> spaceIds = this.spaceMemberDAO.getSpacesIdsByUserName(identity.getRemoteId(), offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (Long spaceId : spaceIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        return this.getMemberSpaces(userId, 0L, -1L);
    }

    public List<Space> getMemberSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getMemberSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), spaceFilter, offset, limit);
    }

    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), spaceFilter);
    }

    public int getMemberSpacesCount(String userId) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(userId, null);
    }

    public int getNumberOfMemberPublicSpaces(String userId) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setNotHidden(true);
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), filter);
    }

    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        return this.getPendingSpaces(userId, 0L, -1L);
    }

    public List<Space> getPendingSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getPendingSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.PENDING), spaceFilter, offset, limit);
    }

    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.PENDING), spaceFilter);
    }

    public int getPendingSpacesCount(String userId) throws SpaceStorageException {
        return this.getPendingSpacesByFilterCount(userId, null);
    }

    public List<Space> getPublicSpaces(String userId) throws SpaceStorageException {
        return this.getPublicSpaces(userId, 0L, -1L);
    }

    public List<Space> getPublicSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getPublicSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        filter.setPublic(userId);
        return this.getSpacesByFilter(filter, offset, limit);
    }

    public int getPublicSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        filter.setPublic(userId);
        return this.getSpacesCount(null, null, filter);
    }

    public int getPublicSpacesCount(String userId) throws SpaceStorageException {
        return this.getPublicSpacesByFilterCount(userId, null);
    }

    public Space getSpaceByDisplayName(String spaceDisplayName) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByDisplayName(spaceDisplayName);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByGroupId(groupId);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceById(String id) throws SpaceStorageException {
        Long spaceId;
        try {
            spaceId = Long.parseLong(id);
        }
        catch (Exception ex) {
            return null;
        }
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(spaceId);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByPrettyName(spacePrettyName);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceByUrl(String url) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByURL(url);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceSimpleById(String id) throws SpaceStorageException {
        Long spaceId;
        try {
            spaceId = Long.parseLong(id);
        }
        catch (Exception ex) {
            return null;
        }
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(spaceId);
        Space space = new Space();
        return this.fillSpaceSimpleFromEntity(entity, space);
    }

    public List<Space> getSpaces(long offset, long limit) throws SpaceStorageException {
        return this.getSpacesByFilter(null, offset, limit);
    }

    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(null, null, spaceFilter, offset, limit);
    }

    public List<Space> getUnifiedSearchSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        throw new UnsupportedOperationException();
    }

    public int getUnifiedSearchSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setUnifiedSearch(true);
        return this.getSpacesCount(null, null, xFilter);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getVisibleSpaces(userId, spaceFilter, 0L, -1L);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setRemoteId(userId);
        xFilter.addStatus(SpaceMemberEntity.Status.MEMBER, SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.INVITED);
        xFilter.setIncludePrivate(true);
        return this.getSpacesByFilter(xFilter, offset, limit);
    }

    public int getVisibleSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setRemoteId(userId);
        xFilter.addStatus(SpaceMemberEntity.Status.MEMBER, SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.INVITED);
        xFilter.setIncludePrivate(true);
        return this.getSpacesCount(userId, null, xFilter);
    }

    public List<Space> getVisitedSpaces(SpaceFilter spaceFilter, int offset, int limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setVisited(true);
        return this.getMemberSpacesByFilter(spaceFilter.getRemoteId(), xFilter, offset, limit);
    }

    public void renameSpace(Space space, String newDisplayName) throws SpaceStorageException {
        this.renameSpace(null, space, newDisplayName);
    }

    public void ignoreSpace(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), null);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(spaceId)));
        if (entity == null) {
            entity = new SpaceMemberEntity();
            entity.setSpace(spaceEntity);
            entity.setUserId(userId);
            entity.setStatus(SpaceMemberEntity.Status.IGNORED);
            this.spaceMemberDAO.create(entity);
        } else {
            this.spaceMemberDAO.delete(entity);
        }
    }

    public boolean isSpaceIgnored(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), SpaceMemberEntity.Status.IGNORED);
        return entity != null;
    }

    public void renameSpace(String remoteId, Space space, String newDisplayName) throws SpaceStorageException {
        String oldPrettyName = space.getPrettyName();
        space.setDisplayName(newDisplayName);
        space.setPrettyName(newDisplayName);
        space.setUrl(SpaceUtils.cleanString(newDisplayName));
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(space.getId())));
        Identity identitySpace = this.identityStorage.findIdentity("space", oldPrettyName);
        EntityConverterUtils.buildFrom(space, entity);
        entity.setUpdatedDate(new Date());
        this.spaceDAO.update(entity);
        if (identitySpace != null) {
            identitySpace.setRemoteId(space.getPrettyName());
            this.identityStorage.saveIdentity(identitySpace);
            Profile profileSpace = identitySpace.getProfile();
            profileSpace.setProperty("Url", (Object)space.getUrl());
            this.identityStorage.saveProfile(profileSpace);
        }
        LOG.debug("Space {} ({}) saved", new Object[]{space.getPrettyName(), space.getId()});
    }

    @ExoTransactional
    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        Space space2 = space;
        boolean bl = isNew;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)space2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, space2, Conversions.booleanObject((boolean)bl), joinPoint};
        RDBMSSpaceStorageImpl$AjcClosure3 rDBMSSpaceStorageImpl$AjcClosure3 = new RDBMSSpaceStorageImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSSpaceStorageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void updateSpaceAccessed(String remoteId, Space space) {
        String string = remoteId;
        Space space2 = space;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)space2);
        Object[] objectArray = new Object[]{this, string, space2, joinPoint};
        RDBMSSpaceStorageImpl$AjcClosure5 rDBMSSpaceStorageImpl$AjcClosure5 = new RDBMSSpaceStorageImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSSpaceStorageImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public List<Space> getPendingSpaceRequestsToManage(String username, int offset, int limit) {
        List<Tuple> spaceRequestsToManage = this.spaceMemberDAO.getPendingSpaceRequestsToManage(username, offset, limit);
        if (spaceRequestsToManage == null || spaceRequestsToManage.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (Tuple tuple : spaceRequestsToManage) {
            Space space = new Space();
            space.setId(tuple.get(1).toString());
            space.setPendingUsers(new String[]{tuple.get(0).toString()});
            spaces.add(space);
        }
        return spaces;
    }

    public int countPendingSpaceRequestsToManage(String username) {
        return this.spaceMemberDAO.countPendingSpaceRequestsToManage(username);
    }

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        List<SpaceExternalInvitationEntity> spaceExternalInvitationEntities = this.spaceExternalInvitationDAO.findSpaceExternalInvitationsBySpaceId(spaceId);
        ArrayList<SpaceExternalInvitation> spaceExternalInvitations = new ArrayList<SpaceExternalInvitation>();
        for (SpaceExternalInvitationEntity spaceExternalInvitationEntity : spaceExternalInvitationEntities) {
            SpaceExternalInvitation spaceExternalInvitation = this.fillSpaceExternalInvitationFromEntity(spaceExternalInvitationEntity);
            spaceExternalInvitations.add(spaceExternalInvitation);
        }
        return spaceExternalInvitations;
    }

    public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        SpaceExternalInvitationEntity spaceExternalInvitation = new SpaceExternalInvitationEntity();
        spaceExternalInvitation.setSpaceId(spaceId);
        spaceExternalInvitation.setUserEmail(email);
        spaceExternalInvitation.setTokenId(tokenId);
        this.spaceExternalInvitationDAO.create(spaceExternalInvitation);
    }

    public SpaceExternalInvitation findSpaceExternalInvitationById(String invitationId) {
        SpaceExternalInvitationEntity spaceExternalInvitationEntity = (SpaceExternalInvitationEntity)this.spaceExternalInvitationDAO.find(Long.valueOf(Long.parseLong(invitationId)));
        return this.fillSpaceExternalInvitationFromEntity(spaceExternalInvitationEntity);
    }

    public void deleteSpaceExternalInvitation(SpaceExternalInvitation spaceExternalInvitation) {
        SpaceExternalInvitationEntity spaceExternalInvitationEntity = (SpaceExternalInvitationEntity)this.spaceExternalInvitationDAO.find(spaceExternalInvitation.getInvitationId());
        this.spaceExternalInvitationDAO.delete(spaceExternalInvitationEntity);
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return this.spaceExternalInvitationDAO.findExternalInvitationsSpacesByEmail(email);
    }

    public void deleteExternalUserInvitations(String email) {
        this.spaceExternalInvitationDAO.deleteExternalUserInvitations(email);
    }

    private String[] getSpaceMembers(long spaceId, SpaceMemberEntity.Status status) {
        int countSpaceMembers = this.spaceMemberDAO.countSpaceMembers(spaceId, status);
        if (countSpaceMembers == 0) {
            return new String[0];
        }
        ArrayList<String> membersList = new ArrayList<String>();
        for (int offset = 0; offset < countSpaceMembers; offset += 100) {
            List<String> spaceMembers = this.spaceMemberDAO.getSpaceMembers(spaceId, status, offset, 100);
            for (String username : spaceMembers) {
                if (StringUtils.isBlank((String)username)) continue;
                membersList.add(username);
            }
        }
        if (membersList.size() < countSpaceMembers) {
            LOG.warn("Space members count '{}' is different from retrieved space members from database {}", new Object[]{countSpaceMembers, membersList.size()});
        }
        return membersList.toArray(new String[0]);
    }

    private Space fillSpaceFromEntity(SpaceEntity entity) {
        if (entity == null) {
            return null;
        }
        Space space = new Space();
        this.fillSpaceSimpleFromEntity(entity, space);
        space.setPendingUsers(this.getSpaceMembers(entity.getId(), SpaceMemberEntity.Status.PENDING));
        space.setInvitedUsers(this.getSpaceMembers(entity.getId(), SpaceMemberEntity.Status.INVITED));
        String[] members = this.getSpaceMembers(entity.getId(), SpaceMemberEntity.Status.MEMBER);
        String[] redactors = this.getSpaceMembers(entity.getId(), SpaceMemberEntity.Status.REDACTOR);
        String[] managers = this.getSpaceMembers(entity.getId(), SpaceMemberEntity.Status.MANAGER);
        HashSet<String> membersList = new HashSet<String>();
        if (members != null) {
            membersList.addAll(Arrays.asList(members));
        }
        if (managers != null) {
            membersList.addAll(Arrays.asList(managers));
        }
        space.setMembers(membersList.toArray(new String[0]));
        space.setRedactors(redactors);
        space.setManagers(managers);
        space.setLastUpdatedTime(entity.getUpdatedDate().getTime());
        return space;
    }

    private List<Space> getSpaces(String userId, List<SpaceMemberEntity.Status> status, SpaceFilter spaceFilter, long offset, long limit) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null && status != null) {
            filter.setRemoteId(userId);
            filter.addStatus(status.toArray(new SpaceMemberEntity.Status[status.size()]));
        }
        if (filter.isUnifiedSearch()) {
            throw new UnsupportedOperationException();
        }
        SpaceQueryBuilder query = SpaceQueryBuilder.builder().filter(filter).offset(offset).limit(limit);
        List entities = query.build().getResultList();
        return this.buildList(entities);
    }

    private int getSpacesCount(String userId, List<SpaceMemberEntity.Status> status, SpaceFilter spaceFilter) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null && status != null) {
            filter.setRemoteId(userId);
            filter.addStatus(status.toArray(new SpaceMemberEntity.Status[status.size()]));
        }
        if (filter.isUnifiedSearch()) {
            throw new UnsupportedOperationException();
        }
        SpaceQueryBuilder query = SpaceQueryBuilder.builder().filter(filter);
        return ((Long)query.buildCount().getSingleResult()).intValue();
    }

    private List<Space> buildList(List<SpaceEntity> spaceEntities) {
        LinkedList<Space> spaces = new LinkedList<Space>();
        if (spaceEntities != null) {
            for (SpaceEntity entity : spaceEntities) {
                Space space = this.fillSpaceFromEntity(entity);
                spaces.add(space);
            }
        }
        return spaces;
    }

    private Space fillSpaceSimpleFromEntity(SpaceEntity entity, Space space) {
        space.setApp(StringUtils.join(entity.getApp(), (String)","));
        space.setId(String.valueOf(entity.getId()));
        space.setDisplayName(entity.getDisplayName());
        space.setPrettyName(entity.getPrettyName());
        if (entity.getRegistration() != null) {
            space.setRegistration(entity.getRegistration().name().toLowerCase());
        }
        space.setDescription(entity.getDescription());
        space.setTemplate(entity.getTemplate());
        if (entity.getVisibility() != null) {
            space.setVisibility(entity.getVisibility().name().toLowerCase());
        }
        if (entity.getPriority() != null) {
            switch (entity.getPriority()) {
                case HIGH: {
                    space.setPriority("1");
                    break;
                }
                case INTERMEDIATE: {
                    space.setPriority("2");
                    break;
                }
                case LOW: {
                    space.setPriority("3");
                    break;
                }
                default: {
                    space.setPriority(null);
                }
            }
        }
        space.setGroupId(entity.getGroupId());
        space.setUrl(entity.getUrl());
        space.setCreatedTime(Long.valueOf(entity.getCreatedDate().getTime()));
        space.setLastUpdatedTime(entity.getUpdatedDate().getTime());
        Date lastUpdated = entity.getAvatarLastUpdated();
        if (lastUpdated != null) {
            space.setAvatarLastUpdated(Long.valueOf(entity.getAvatarLastUpdated().getTime()));
        }
        space.setAvatarUrl(LinkProvider.buildAvatarURL("space", space.getPrettyName(), lastUpdated == null ? null : Long.valueOf(lastUpdated.getTime())));
        lastUpdated = entity.getBannerLastUpdated();
        if (lastUpdated != null) {
            space.setBannerLastUpdated(Long.valueOf(lastUpdated.getTime()));
        }
        space.setBannerUrl(LinkProvider.buildBannerURL("space", space.getPrettyName(), lastUpdated == null ? null : Long.valueOf(lastUpdated.getTime())));
        return space;
    }

    private SpaceExternalInvitation fillSpaceExternalInvitationFromEntity(SpaceExternalInvitationEntity spaceExternalInvitationEntity) {
        SpaceExternalInvitation spaceExternalInvitation = new SpaceExternalInvitation();
        spaceExternalInvitation.setInvitationId(spaceExternalInvitationEntity.getInvitationId());
        spaceExternalInvitation.setSpaceId(spaceExternalInvitationEntity.getSpaceId());
        spaceExternalInvitation.setUserEmail(spaceExternalInvitationEntity.getUserEmail());
        spaceExternalInvitation.setTokenId(spaceExternalInvitationEntity.getTokenId());
        RemindPasswordTokenService remindPasswordTokenService = (RemindPasswordTokenService)CommonsUtils.getService(RemindPasswordTokenService.class);
        GateInToken token = null;
        if (remindPasswordTokenService != null) {
            token = remindPasswordTokenService.getToken(spaceExternalInvitationEntity.getTokenId(), "external-registration");
        }
        spaceExternalInvitation.setExpired(token == null || token.isExpired());
        return spaceExternalInvitation;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    static {
        RDBMSSpaceStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSSpaceStorageImpl.class);
    }

    static /* synthetic */ void deleteSpace_aroundBody0(RDBMSSpaceStorageImpl ajc$this, String id, JoinPoint joinPoint) {
        SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(Long.valueOf(Long.parseLong(id)));
        if (entity != null) {
            Identity spaceIdentity = ajc$this.identityStorage.findIdentity("space", entity.getPrettyName());
            if (spaceIdentity == null) {
                LOG.warn("Space with pretty name '{}' hasn't a related identity", new Object[]{entity.getPrettyName()});
            } else {
                ajc$this.identityDAO.hardDeleteIdentity(Long.parseLong(spaceIdentity.getId()));
                ajc$this.activityDAO.deleteActivitiesByOwnerId(spaceIdentity.getId());
            }
            ajc$this.spaceDAO.delete(entity);
            LOG.debug("Space {} removed", new Object[]{entity.getPrettyName()});
        }
    }

    static /* synthetic */ void saveSpace_aroundBody2(RDBMSSpaceStorageImpl ajc$this, Space space, boolean isNew, JoinPoint joinPoint) {
        if (isNew) {
            SpaceEntity entity = new SpaceEntity();
            EntityConverterUtils.buildFrom(space, entity);
            entity.setUpdatedDate(new Date());
            ajc$this.spaceDAO.create(entity);
            space.setId(String.valueOf(entity.getId()));
        } else {
            Long id = Long.parseLong(space.getId());
            SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(id);
            if (entity != null) {
                EntityConverterUtils.buildFrom(space, entity);
                entity.setUpdatedDate(new Date());
                ajc$this.spaceDAO.update(entity);
            } else {
                throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_SAVE_SPACE);
            }
        }
        LOG.debug("Space {} ({}) saved", new Object[]{space.getPrettyName(), space.getId()});
    }

    static /* synthetic */ void updateSpaceAccessed_aroundBody4(RDBMSSpaceStorageImpl ajc$this, String remoteId, Space space, JoinPoint joinPoint) {
        SpaceMemberEntity member = ajc$this.spaceMemberDAO.getSpaceMemberShip(remoteId, Long.parseLong(space.getId()), SpaceMemberEntity.Status.MEMBER);
        if (member != null) {
            member.setVisited(true);
            member.setLastAccess(new Date());
        }
        ajc$this.spaceMemberDAO.update(member);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSSpaceStorageImpl.java", RDBMSSpaceStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String", "id", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "org.exoplatform.social.core.space.model.Space:boolean", "space:isNew", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 503);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSpaceAccessed", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String:org.exoplatform.social.core.space.model.Space", "remoteId:space", "", "void"), 531);
    }
}

