/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.mfa.storage.dao.RevocationRequestDAO;
import org.exoplatform.mfa.storage.dto.RevocationRequest;
import org.exoplatform.mfa.storage.entity.RevocationRequestEntity;

public class MfaStorage {
    private final RevocationRequestDAO revocationRequestDAO;

    public MfaStorage(RevocationRequestDAO revocationRequestDAO) {
        this.revocationRequestDAO = revocationRequestDAO;
    }

    public RevocationRequest createRevocationRequest(RevocationRequest revocationRequest) {
        if (revocationRequest == null) {
            throw new IllegalArgumentException("RevocationRequest is mandatory");
        }
        RevocationRequestEntity revocationRequestEntity = this.toEntity(revocationRequest);
        revocationRequestEntity.setId(null);
        revocationRequestEntity = (RevocationRequestEntity)this.revocationRequestDAO.create(revocationRequestEntity);
        return this.toDTO(revocationRequestEntity);
    }

    public RevocationRequest findById(Long id) {
        return this.toDTO(this.revocationRequestDAO.findById(id));
    }

    public List<RevocationRequest> findAll() {
        return this.revocationRequestDAO.findAll().stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countByUsernameAndType(String username, String type) {
        return this.revocationRequestDAO.countByUsernameAndType(username, type);
    }

    public void deleteRevocationRequest(String username, String type) {
        this.revocationRequestDAO.deleteByUsernameAndType(username, type);
    }

    public void deleteById(Long id) {
        this.revocationRequestDAO.deleteById(id);
    }

    private RevocationRequestEntity toEntity(RevocationRequest revocationRequest) {
        if (revocationRequest == null) {
            return null;
        }
        return new RevocationRequestEntity(revocationRequest.getId(), revocationRequest.getUser(), revocationRequest.getType());
    }

    private RevocationRequest toDTO(RevocationRequestEntity revocationRequestEntity) {
        if (revocationRequestEntity == null) {
            return null;
        }
        return new RevocationRequest(revocationRequestEntity.getId(), revocationRequestEntity.getUsername(), revocationRequestEntity.getType());
    }
}

