/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.ActivityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListActivitiesData;
import org.exoplatform.social.core.storage.cache.model.key.ActivityCountKey;
import org.exoplatform.social.core.storage.cache.model.key.ActivityKey;
import org.exoplatform.social.core.storage.cache.model.key.ActivityType;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListActivitiesKey;
import org.exoplatform.social.core.storage.cache.selector.ActivityAttachmentCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.ActivityOwnerCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.ActivityStreamOwnerCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.CacheSelector;

public class CachedActivityStorage
implements ActivityStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedActivityStorage.class);
    private final ExoCache<ActivityKey, ActivityData> exoActivityCache;
    private final ExoCache<ActivityCountKey, IntegerData> exoActivitiesCountCache;
    private final ExoCache<ListActivitiesKey, ListActivitiesData> exoActivitiesCache;
    private final FutureExoCache<ActivityKey, ActivityData, ServiceContext<ActivityData>> activityCache;
    private final FutureExoCache<ActivityCountKey, IntegerData, ServiceContext<IntegerData>> activitiesCountCache;
    private final FutureExoCache<ListActivitiesKey, ListActivitiesData, ServiceContext<ListActivitiesData>> activitiesCache;
    private ActivityStorage storage;

    public void clearCache() {
        try {
            this.exoActivitiesCache.select(new CacheSelector());
            this.exoActivitiesCountCache.select(new CacheSelector());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    void clearOwnerCache(String ownerId) {
        try {
            this.exoActivityCache.select((CachedObjectSelector)new ActivityOwnerCacheSelector(ownerId));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.clearCache();
    }

    void clearOwnerStreamCache(String streamOwner) {
        try {
            this.exoActivityCache.select((CachedObjectSelector)new ActivityStreamOwnerCacheSelector(streamOwner));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.clearCache();
    }

    public void clearActivityCached(String activityId) {
        ActivityKey key = new ActivityKey(activityId);
        this.exoActivityCache.remove((Serializable)key);
        this.clearCache();
    }

    private List<ExoSocialActivity> buildActivities(ListActivitiesData data) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        for (ActivityKey k : data.getIds()) {
            ExoSocialActivity a = this.getActivity(k.getId());
            activities.add(a);
        }
        return activities;
    }

    private ListActivitiesData buildIds(List<ExoSocialActivity> activities) {
        ArrayList<ActivityKey> data = new ArrayList<ActivityKey>();
        for (ExoSocialActivity a : activities) {
            if (a == null) continue;
            ActivityKey k = new ActivityKey(a.getId());
            if (this.exoActivityCache.get((Serializable)k) == null) {
                this.exoActivityCache.putLocal((Serializable)k, (Object)new ActivityData(a));
            }
            data.add(k);
        }
        return new ListActivitiesData((List<ActivityKey>)data);
    }

    private ListActivitiesData buildActivityIds(List<String> ids) {
        ArrayList<ActivityKey> data = new ArrayList<ActivityKey>();
        for (String id : ids) {
            ActivityKey k = new ActivityKey(id);
            data.add(k);
        }
        return new ListActivitiesData((List<ActivityKey>)data);
    }

    public CachedActivityStorage(RDBMSActivityStorageImpl storage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.exoActivityCache = cacheService.getActivityCache();
        this.exoActivitiesCountCache = cacheService.getActivitiesCountCache();
        this.exoActivitiesCache = cacheService.getActivitiesCache();
        this.exoActivityCache.addCacheListener((CacheListener)new CacheActivityListener());
        this.activityCache = CacheType.ACTIVITY.createFutureCache(this.exoActivityCache);
        this.activitiesCountCache = CacheType.ACTIVITIES_COUNT.createFutureCache(this.exoActivitiesCountCache);
        this.activitiesCache = CacheType.ACTIVITIES.createFutureCache(this.exoActivitiesCache);
    }

    public ExoSocialActivity getActivity(final String activityId) throws ActivityStorageException {
        if (activityId == null || activityId.length() == 0) {
            return ActivityData.NULL.build();
        }
        ActivityKey key = new ActivityKey(activityId);
        ActivityData activity = (ActivityData)this.activityCache.get((Object)new ServiceContext<ActivityData>(){

            @Override
            public ActivityData execute() {
                try {
                    ExoSocialActivity got = CachedActivityStorage.this.storage.getActivity(activityId);
                    if (got != null) {
                        return new ActivityData(got);
                    }
                    return ActivityData.NULL;
                }
                catch (Exception e) {
                    throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, "failed to get activity with id: " + activityId, (Throwable)e);
                }
            }
        }, (Object)key);
        return activity.build();
    }

    public boolean isActivityExists(String activityId) {
        boolean cachedActivityExists;
        ActivityKey key = new ActivityKey(activityId);
        ActivityData cachedActivityData = (ActivityData)this.exoActivityCache.get((Serializable)key);
        boolean bl = cachedActivityExists = cachedActivityData != null && cachedActivityData.getId() != null;
        if (cachedActivityExists) {
            return true;
        }
        return this.storage.isActivityExists(activityId);
    }

    public List<ExoSocialActivity> getUserActivities(Identity owner) throws ActivityStorageException {
        return this.storage.getUserActivities(owner);
    }

    public List<ExoSocialActivity> getUserActivities(final Identity owner, final long offset, final long limit) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, offset, limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserActivities(owner, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<String> getUserIdsActivities(final Identity owner, final long offset, final long limit) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, offset, limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserIdsActivities(owner, offset, limit);
                return CachedActivityStorage.this.buildActivityIds(got);
            }
        }, (Object)listKey);
        return this.buildActivityIds(keys);
    }

    public void saveComment(ExoSocialActivity activity, ExoSocialActivity comment) throws ActivityStorageException {
        this.storage.saveComment(activity, comment);
        this.exoActivityCache.remove((Serializable)new ActivityKey(comment.getId()));
        this.exoActivityCache.put((Serializable)new ActivityKey(comment.getId()), (Object)new ActivityData(this.getActivity(comment.getId())));
        ActivityKey activityKey = new ActivityKey(activity.getId());
        this.exoActivityCache.remove((Serializable)activityKey);
        this.exoActivityCache.put((Serializable)activityKey, (Object)new ActivityData(this.getActivity(activity.getId())));
    }

    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        ExoSocialActivity a = this.storage.saveActivity(owner, activity);
        ActivityKey key = new ActivityKey(a.getId());
        this.exoActivityCache.put((Serializable)key, (Object)new ActivityData(this.getActivity(a.getId())));
        return a;
    }

    public ExoSocialActivity hideActivity(String activityId) {
        ExoSocialActivity a = this.storage.hideActivity(activityId);
        ActivityKey key = new ActivityKey(a.getId());
        this.exoActivityCache.remove((Serializable)key);
        return a;
    }

    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) throws ActivityStorageException {
        return this.getActivity(comment.getParentId());
    }

    public void deleteActivity(String activityId) throws ActivityStorageException {
        ExoSocialActivity a = this.storage.getActivity(activityId);
        this.storage.deleteActivity(activityId);
        ActivityKey key = new ActivityKey(activityId);
        this.exoActivityCache.remove((Serializable)key);
    }

    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        this.storage.deleteComment(activityId, commentId);
        this.exoActivityCache.remove((Serializable)new ActivityKey(commentId));
        ActivityKey activityKey = new ActivityKey(activityId);
        this.exoActivityCache.remove((Serializable)activityKey);
    }

    public int getNumberOfUserActivities(final Identity owner) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfUserActivities(owner));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnUserActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_USER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnUserActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerOnUserActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.NEWER_USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerOnUserActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnUserActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_USER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnUserActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getOlderOnUserActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderOnUserActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivityFeed(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivityFeed(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<String> getActivityIdsFeed(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivityIdsFeed(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildActivityIds(got);
            }
        }, (Object)listKey);
        return this.buildActivityIds(keys);
    }

    private List<String> buildActivityIds(ListActivitiesData data) {
        LinkedList<String> ids = new LinkedList<String>();
        for (ActivityKey k : data.getIds()) {
            ids.add(k.getId());
        }
        return ids;
    }

    public int getNumberOfActivitesOnActivityFeed(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitesOnActivityFeed(ownerIdentity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnActivityFeed(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_FEED);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnActivityFeed(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerOnActivityFeed(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerOnActivityFeed(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnActivityFeed(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_FEED);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnActivityFeed(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getOlderOnActivityFeed(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderOnActivityFeed(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivitiesOfConnections(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivitiesOfConnections(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<String> getActivityIdsOfConnections(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivityIdsOfConnections(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildActivityIds(got);
            }
        }, (Object)listKey);
        return this.buildActivityIds(keys);
    }

    public int getNumberOfActivitiesOfConnections(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitiesOfConnections(ownerIdentity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity ownerIdentity, long offset, long limit) throws ActivityStorageException {
        return this.storage.getActivitiesOfIdentity(ownerIdentity, offset, limit);
    }

    public int getNumberOfNewerOnActivitiesOfConnections(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_CONNECTION);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final long limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerOnActivitiesOfConnections(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnActivitiesOfConnections(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_CONNECTION);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderOnActivitiesOfConnections(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getUserSpacesActivities(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserSpacesActivities(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<String> getUserSpacesActivityIds(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserSpacesActivityIds(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildActivityIds(got);
            }
        }, (Object)listKey);
        return this.buildActivityIds(keys);
    }

    public int getNumberOfUserSpacesActivities(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfUserSpacesActivities(ownerIdentity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnUserSpacesActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_SPACES);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerOnUserSpacesActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnUserSpacesActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_SPACES);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderOnUserSpacesActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity, boolean loadSubComments, int offset, int limit) {
        return this.getComments(existingActivity, loadSubComments, offset, limit, false);
    }

    public List<ExoSocialActivity> getComments(final ExoSocialActivity existingActivity, final boolean loadSubComments, final int offset, final int limit, final boolean sortDescending) {
        ActivityCountKey key = new ActivityCountKey(existingActivity.getId(), loadSubComments ? ActivityType.COMMENTS_AND_SUB_COMMENTS : ActivityType.COMMENTS);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit, sortDescending);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getComments(existingActivity, loadSubComments, offset, limit, sortDescending);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfComments(final ExoSocialActivity existingActivity) {
        ActivityCountKey key = new ActivityCountKey(existingActivity.getId(), ActivityType.COMMENTS);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfComments(existingActivity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.storage.getNumberOfNewerComments(existingActivity, baseComment);
    }

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.storage.getNewerComments(existingActivity, baseComment, limit);
    }

    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.storage.getNumberOfOlderComments(existingActivity, baseComment);
    }

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.storage.getOlderComments(existingActivity, baseComment, limit);
    }

    public SortedSet<ActivityProcessor> getActivityProcessors() {
        return this.storage.getActivityProcessors();
    }

    public void updateActivity(ExoSocialActivity existingActivity) throws ActivityStorageException {
        this.storage.updateActivity(existingActivity);
        ActivityKey key = new ActivityKey(existingActivity.getId());
        this.exoActivityCache.remove((Serializable)key);
    }

    public int getNumberOfNewerOnActivityFeed(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.NEWER_FEED);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnActivityFeed(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnUserActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.NEWER_USER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnUserActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnActivitiesOfConnections(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.NEWER_CONNECTION);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnUserSpacesActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.NEWER_SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfSpaceActivities(final Identity spaceIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(spaceIdentity), ActivityType.SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfSpaceActivities(spaceIdentity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfSpaceActivitiesForUpgrade(final Identity spaceIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(spaceIdentity), ActivityType.SPACE_FOR_UPGRADE);
        IntegerData countData = (IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfSpaceActivitiesForUpgrade(spaceIdentity));
            }
        }, (Object)key);
        ActivityCountKey keySpace = new ActivityCountKey(new IdentityKey(spaceIdentity), ActivityType.SPACE);
        this.exoActivitiesCountCache.putLocal((Serializable)keySpace, (Object)countData);
        return (Integer)countData.build();
    }

    public List<ExoSocialActivity> getSpaceActivities(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getSpaceActivities(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<String> getSpaceActivityIds(final Identity spaceIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(spaceIdentity), ActivityType.SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getSpaceActivityIds(spaceIdentity, offset, limit);
                return CachedActivityStorage.this.buildActivityIds(got);
            }
        }, (Object)listKey);
        return this.buildActivityIds(keys);
    }

    public List<ExoSocialActivity> getSpaceActivitiesForUpgrade(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getSpaceActivitiesForUpgrade(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivitiesByPoster(final Identity posterIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(posterIdentity), ActivityType.POSTER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivitiesByPoster(posterIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivitiesByPoster(final Identity posterIdentity, final int offset, final int limit, final String ... activityTypes) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(posterIdentity), ActivityType.POSTER, activityTypes);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivitiesByPoster(posterIdentity, offset, limit, activityTypes);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfActivitiesByPoster(final Identity posterIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(posterIdentity), ActivityType.POSTER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitiesByPoster(posterIdentity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfActivitiesByPoster(final Identity ownerIdentity, final Identity viewerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), new IdentityKey(viewerIdentity), ActivityType.POSTER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitiesByPoster(ownerIdentity, viewerIdentity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerOnSpaceActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerOnSpaceActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfNewerOnSpaceActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.NEWER_SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnSpaceActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getOlderOnSpaceActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderOnSpaceActivities(ownerIdentity, baseActivity, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnSpaceActivities(final Identity ownerIdentity, final ExoSocialActivity baseActivity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), baseActivity.getId(), ActivityType.OLDER_SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnSpaceActivities(ownerIdentity, baseActivity));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfNewerOnSpaceActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.NEWER_SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerFeedActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.NEWER_FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerFeedActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getNewerSpaceActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.NEWER_SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerSpaceActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getNewerUserActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.NEWER_USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerUserActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getNewerUserSpacesActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.NEWER_SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerUserSpacesActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getNewerActivitiesOfConnections(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.NEWER_CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerActivitiesOfConnections(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivities(final Identity owner, final Identity viewer, final long offset, final long limit) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), new IdentityKey(viewer), ActivityType.VIEWER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, offset, limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivities(owner, viewer, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderFeedActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.OLDER_FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderFeedActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderUserActivities(final Identity ownerIdentity, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderUserActivities(ownerIdentity, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderUserSpacesActivities(final Identity ownerIdentity, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderUserSpacesActivities(ownerIdentity, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderActivitiesOfConnections(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.OLDER_CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderActivitiesOfConnections(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderSpaceActivities(final Identity owner, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), sinceTime, ActivityType.OLDER_SPACE);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderSpaceActivities(owner, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfOlderOnActivityFeed(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_FEED);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnActivityFeed(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfOlderOnUserActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_USER);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnUserActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfOlderOnActivitiesOfConnections(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_CONNECTION);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfOlderOnUserSpacesActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_SPACES);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfOlderOnSpaceActivities(final Identity ownerIdentity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), sinceTime, ActivityType.OLDER_SPACE);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderOnSpaceActivities(ownerIdentity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getNewerComments(final ExoSocialActivity existingActivity, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new ActivityKey(existingActivity.getId()), sinceTime, ActivityType.NEWER_COMMENTS);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getNewerComments(existingActivity, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getOlderComments(final ExoSocialActivity existingActivity, final Long sinceTime, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new ActivityKey(existingActivity.getId()), sinceTime, ActivityType.OLDER_COMMENTS);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getOlderComments(existingActivity, sinceTime, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfNewerComments(final ExoSocialActivity existingActivity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new ActivityKey(existingActivity.getId()), sinceTime, ActivityType.NEWER_COMMENTS);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfNewerComments(existingActivity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public int getNumberOfOlderComments(final ExoSocialActivity existingActivity, final Long sinceTime) {
        ActivityCountKey key = new ActivityCountKey(new ActivityKey(existingActivity.getId()), sinceTime, ActivityType.OLDER_COMMENTS);
        return (Integer)((IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfOlderComments(existingActivity, sinceTime));
            }
        }, (Object)key)).build();
    }

    public List<ExoSocialActivity> getUserActivitiesForUpgrade(final Identity owner, final long offset, final long limit) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER);
        ListActivitiesKey listKey = new ListActivitiesKey(key, offset, limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserActivitiesForUpgrade(owner, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfUserActivitiesForUpgrade(final Identity owner) throws ActivityStorageException {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER_FOR_UPGRADE);
        IntegerData countData = (IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfUserActivitiesForUpgrade(owner));
            }
        }, (Object)key);
        ActivityCountKey keyUser = new ActivityCountKey(new IdentityKey(owner), ActivityType.USER);
        this.exoActivitiesCountCache.putLocal((Serializable)keyUser, (Object)countData);
        return (Integer)countData.build();
    }

    public List<ExoSocialActivity> getActivityFeedForUpgrade(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivityFeedForUpgrade(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfActivitesOnActivityFeedForUpgrade(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED_FOR_UPGRADE);
        IntegerData countData = (IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitesOnActivityFeedForUpgrade(ownerIdentity));
            }
        }, (Object)key);
        ActivityCountKey keyFeed = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.FEED);
        this.exoActivitiesCountCache.putLocal((Serializable)keyFeed, (Object)countData);
        return (Integer)countData.build();
    }

    public List<ExoSocialActivity> getActivitiesOfConnectionsForUpgrade(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getActivitiesOfConnectionsForUpgrade(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfActivitiesOfConnectionsForUpgrade(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION_FOR_UPGRADE);
        IntegerData countData = (IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfActivitiesOfConnectionsForUpgrade(ownerIdentity));
            }
        }, (Object)key);
        ActivityCountKey keyConnection = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.CONNECTION);
        this.exoActivitiesCountCache.putLocal((Serializable)keyConnection, (Object)countData);
        return (Integer)countData.build();
    }

    public List<ExoSocialActivity> getUserSpacesActivitiesForUpgrade(final Identity ownerIdentity, final int offset, final int limit) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES);
        ListActivitiesKey listKey = new ListActivitiesKey(key, (long)offset, (long)limit);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getUserSpacesActivitiesForUpgrade(ownerIdentity, offset, limit);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public int getNumberOfUserSpacesActivitiesForUpgrade(final Identity ownerIdentity) {
        ActivityCountKey key = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES_FOR_UPGRADE);
        IntegerData countData = (IntegerData)this.activitiesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedActivityStorage.this.storage.getNumberOfUserSpacesActivitiesForUpgrade(ownerIdentity));
            }
        }, (Object)key);
        ActivityCountKey keySpaces = new ActivityCountKey(new IdentityKey(ownerIdentity), ActivityType.SPACES);
        this.exoActivitiesCountCache.putLocal((Serializable)keySpaces, (Object)countData);
        return (Integer)countData.build();
    }

    public List<ExoSocialActivity> getAllActivities(int index, int limit) {
        return this.storage.getAllActivities(index, limit);
    }

    public List<ExoSocialActivity> getSubComments(final ExoSocialActivity comment) {
        ActivityCountKey key = new ActivityCountKey(comment.getId(), ActivityType.SUB_COMMENTS);
        ListActivitiesKey listKey = new ListActivitiesKey(key, 0L, Integer.MAX_VALUE);
        ListActivitiesData keys = (ListActivitiesData)this.activitiesCache.get((Object)new ServiceContext<ListActivitiesData>(){

            @Override
            public ListActivitiesData execute() {
                List got = CachedActivityStorage.this.storage.getSubComments(comment);
                return CachedActivityStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildActivities(keys);
    }

    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        if (activityIdList == null || activityIdList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> activityIdsToGetFromStore = new ArrayList<String>();
        HashMap<String, ExoSocialActivity> resultMap = new HashMap<String, ExoSocialActivity>();
        for (String string : activityIdList) {
            ActivityData activityData = (ActivityData)this.exoActivityCache.get((Serializable)new ActivityKey(string));
            if (activityData == null) {
                activityIdsToGetFromStore.add(string);
                continue;
            }
            if (activityData == ActivityData.NULL || activityData.getId() == null) continue;
            resultMap.put(string, activityData.build());
        }
        List activitiesGotFromStore = this.storage.getActivities(activityIdsToGetFromStore);
        if (activitiesGotFromStore != null && !activitiesGotFromStore.isEmpty()) {
            for (ExoSocialActivity exoSocialActivity : activitiesGotFromStore) {
                this.activityCache.putOnly((Serializable)new ActivityKey(exoSocialActivity.getId()), (Object)new ActivityData(exoSocialActivity));
                resultMap.put(exoSocialActivity.getId(), exoSocialActivity);
            }
        }
        ArrayList<ExoSocialActivity> arrayList = new ArrayList<ExoSocialActivity>();
        for (String activityId : activityIdList) {
            ExoSocialActivity exoSocialActivity = (ExoSocialActivity)resultMap.get(activityId);
            if (exoSocialActivity == null) continue;
            arrayList.add(exoSocialActivity);
        }
        return arrayList;
    }

    public Set<Long> getStreamFeedOwnerIds(Identity identity) {
        return this.storage.getStreamFeedOwnerIds(identity);
    }

    public ActivityShareAction createShareActivityAction(ActivityShareAction activityShareAction) {
        activityShareAction = this.storage.createShareActivityAction(activityShareAction);
        ActivityKey key = new ActivityKey(String.valueOf(activityShareAction.getActivityId()));
        this.exoActivityCache.remove((Serializable)key);
        return activityShareAction;
    }

    public void clearActivityCachedByAttachmentId(String attachmentId) {
        try {
            this.exoActivityCache.select((CachedObjectSelector)new ActivityAttachmentCacheSelector(attachmentId));
        }
        catch (Exception e) {
            LOG.error("Error clearing cache of activities having attachment with id {}", new Object[]{attachmentId, e});
        }
    }

    private class CacheActivityListener
    implements CacheListener<ActivityKey, ActivityData> {
        private CacheActivityListener() {
        }

        public void onExpire(CacheListenerContext context, ActivityKey key, ActivityData obj) throws Exception {
        }

        public void onRemove(CacheListenerContext context, ActivityKey key, ActivityData obj) throws Exception {
            CachedActivityStorage.this.clearCache();
        }

        public void onPut(CacheListenerContext context, ActivityKey key, ActivityData obj) throws Exception {
            CachedActivityStorage.this.clearCache();
        }

        public void onPutLocal(CacheListenerContext context, ActivityKey key, ActivityData obj) throws Exception {
        }

        public void onGet(CacheListenerContext context, ActivityKey key, ActivityData obj) throws Exception {
        }

        public void onClearCache(CacheListenerContext context) throws Exception {
        }
    }
}

