/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.supplier;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionSupplier;

public class MSSQLConnSupplier
extends ConnectionSupplier {
    @Override
    public String getDatabaseShortName() {
        return "mssql";
    }

    public String getInstanceName() {
        return "MSSQLSERVER";
    }

    @Override
    public String getAdminUsername() {
        return "sa";
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:sqlserver://" + this.getIpAddress() + ":1433;databaseName=" + this.getPrimaryCatalog();
    }

    @Override
    public String getOs() {
        return "windows";
    }

    @Override
    public ConnectionSupplier.ConfigTemplate getPuppetTemplate(Map<String, Object> context) {
        return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mssql/mssql.puppet.vm", context);
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "Instance name: " + this.getInstanceName() + "\n" + "\n" + "REQUIRES: You must manually download the sql server express installation files into LIQUIBASE_HOME/sdk/vagrant/install-files/mssql/SQLEXPR_x64_ENU.exe\n" + "      You can download the install files from http://www.microsoft.com/en-us/sqlserver/get-sql-server/try-it.aspx#tab2\n" + "\n" + "NOTE: If Exec[mssql install] fails, you may need to remote desktop to the vagrant box and run the failed command locally. After running, re-run liquibase-sdk vagrant [BOX_NAME] provision. Watch the process manager for SQLEXPR_x64_ENU.exe to exit. You may want to change the '/q' flag to '/qs' for more feedback.\n" + "\n";
    }

    @Override
    public Set<ConnectionSupplier.ConfigTemplate> generateConfigFiles(Map<String, Object> context) throws IOException {
        Set<ConnectionSupplier.ConfigTemplate> configTemplates = super.generateConfigFiles(context);
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mssql/mssql.init.sql.vm", context));
        return configTemplates;
    }
}

