/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.WikiHTMLSanitizer;

@Path(value="/notes")
@Api(value="/notes", description="Managing notes")
@RolesAllowed(value={"users"})
public class NotesRestService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(NotesRestService.class);
    private final NoteService noteService;
    private final WikiService noteBookService;
    private final ResourceBundleService resourceBundleService;
    private final CacheControl cc;

    public NotesRestService(NoteService noteService, WikiService noteBookService, ResourceBundleService resourceBundleService) {
        this.noteService = noteService;
        this.noteBookService = noteBookService;
        this.resourceBundleService = resourceBundleService;
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get note by notes params", httpMethod="GET", response=Response.class, notes="This get the not if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getNote(@ApiParam(value="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @ApiParam(value="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId, @ApiParam(value="source", required=true) @QueryParam(value="source") String source) {
        try {
            Page note;
            Identity identity = ConversationState.getCurrent().getIdentity();
            Wiki noteBook = null;
            noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                noteBook = this.noteBookService.createWiki(noteBookType, noteBookOwner);
            }
            if ((note = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity, source)) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            note.setContent(WikiHTMLSanitizer.markupSanitize(note.getContent()));
            note.setBreadcrumb(this.noteService.getBreadcumb(noteBookType, noteBookOwner, noteId));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error("Can't get note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/note/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get note by id", httpMethod="GET", response=Response.class, notes="This get the not if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getNoteById(@ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId, @ApiParam(value="noteBookType", required=false) @QueryParam(value="noteBookType") String noteBookType, @ApiParam(value="noteBookOwner", required=false) @QueryParam(value="noteBookOwner") String noteBookOwner, @ApiParam(value="source", required=false) @QueryParam(value="source") String source) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity, source);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((String)noteBookType) && !note.getWikiType().equals(noteBookType)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((String)noteBookOwner) && !note.getWikiOwner().equals(noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            note.setContent(WikiHTMLSanitizer.markupSanitize(note.getContent()));
            note.setBreadcrumb(this.noteService.getBreadcumb(note.getWikiType(), note.getWikiOwner(), note.getName()));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error("Can't get note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/note")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Add a new note", httpMethod="POST", response=Response.class, notes="This adds a new note.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response createNote(@ApiParam(value="note object to be created", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        String noteBookType = note.getWikiType();
        String noteBookOwner = note.getWikiOwner();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNotEmpty((String)note.getParentPageId())) {
                Page note_ = this.noteService.getNoteById(note.getParentPageId(), identity);
                if (note_ != null) {
                    noteBookType = note_.getWikiType();
                    noteBookOwner = note_.getWikiOwner();
                    note.setParentPageName(note_.getName());
                } else {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (StringUtils.isEmpty((String)noteBookType) || StringUtils.isEmpty((String)noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (this.noteBookService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Note name already exists").build();
            }
            Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String syntaxId = this.noteBookService.getDefaultWikiSyntaxId();
            String currentUser = identity.getUserId();
            note.setAuthor(currentUser);
            note.setOwner(currentUser);
            note.setSyntax(syntaxId);
            note.setName(TitleResolver.getId(note.getTitle(), false));
            note.setUrl("");
            Page createdNote = this.noteService.createNote(noteBook, note.getParentPageName(), note, identity);
            return Response.ok((Object)createdNote, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{note.getName(), e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform save noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific note by note's params", httpMethod="PUT", response=Response.class, notes="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response updateNote(@ApiParam(value="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @ApiParam(value="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId, @ApiParam(value="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!this.noteService.hasPermissionOnNote(note_, PermissionType.EDITPAGE, identity)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            note_.setToBePublished(note.isToBePublished());
            if (!note_.getTitle().equals(note.getTitle()) && this.noteBookService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Note name already exists").build();
            }
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                note_.setTitle(note.getTitle());
                note_.setContent(note.getContent());
                if (!"WikiHome".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams wikiPageParams = new WikiPageParams(noteBookType, noteBookOwner, newNoteName);
                }
            } else if (!note_.getTitle().equals(note.getTitle())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                if (!"WikiHome".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_.setTitle(note.getTitle());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                this.noteService.createVersionOfNote(note_);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams wikiPageParams = new WikiPageParams(noteBookType, noteBookOwner, newNoteName);
                }
            } else if (!note_.getContent().equals(note.getContent())) {
                note_.setContent(note.getContent());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                this.noteService.createVersionOfNote(note_);
            }
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific note by id", httpMethod="PUT", response=Response.class, notes="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response updateNoteById(@ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId, @ApiParam(value="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteById(noteId, identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!this.noteService.hasPermissionOnNote(note_, PermissionType.EDITPAGE, identity)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            note_.setToBePublished(note.isToBePublished());
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                note_.setTitle(note.getTitle());
                note_.setContent(note.getContent());
                if (!"WikiHome".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams);
                }
            } else if (!note_.getTitle().equals(note.getTitle())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                if (!"WikiHome".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_.setTitle(note.getTitle());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                this.noteService.createVersionOfNote(note_);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams);
                }
            } else if (!note_.getContent().equals(note.getContent())) {
                note_.setContent(note.getContent());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                this.noteService.createVersionOfNote(note_);
            }
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have edit permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete note by note's params", httpMethod="PUT", response=Response.class, notes="This delets the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response deleteNote(@ApiParam(value="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @ApiParam(value="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.noteService.deleteNote(noteBookType, noteBookOwner, noteId, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform Delete of noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete note by note's params", httpMethod="PUT", response=Response.class, notes="This delets the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response deleteNoteById(@ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            String noteName = note.getName();
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), noteName, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform Delete of noteBook note {}", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PATCH
    @Path(value="/note/move/{noteId}/{destinationNoteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Move note under the destination one", httpMethod="PUT", response=Response.class, notes="This moves the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response moveNote(@ApiParam(value="Note id", required=true) @PathParam(value="noteId") String noteId, @ApiParam(value="Destination Note id", required=true) @PathParam(value="destinationNoteId") String toNoteId) {
        try {
            WikiPageParams newLocationParams;
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Page toNote = this.noteService.getNoteById(toNoteId);
            if (toNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            WikiPageParams currentLocationParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
            boolean isMoved = this.noteService.moveNote(currentLocationParams, newLocationParams = new WikiPageParams(toNote.getWikiType(), toNote.getWikiOwner(), toNote.getName()), identity);
            if (isMoved) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have move permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform move of noteBook note {} under {}", new Object[]{noteId, toNoteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/tree/{type}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get node's tree", httpMethod="GET", response=Response.class, notes="Display the current tree of a noteBook based on is path")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getTreeData(@PathParam(value="type") String type, @QueryParam(value="path") String path, @QueryParam(value="page") String currentPath, @QueryParam(value="canEdit") Boolean canEdit, @QueryParam(value="excerpt") Boolean showExcerpt, @QueryParam(value="depth") String depth) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            List<JsonNodeData> responseData = new ArrayList<JsonNodeData>();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("canEdit", canEdit);
            if (currentPath != null) {
                currentPath = URLDecoder.decode(currentPath, "utf-8");
                context.put("page", currentPath);
                WikiPageParams currentNoteParam = TreeUtils.getPageParamsFromPath(currentPath);
                Page currentNote = this.noteService.getNoteOfNoteBookByName(currentNoteParam.getType(), currentNoteParam.getOwner(), currentNoteParam.getPageName(), identity);
                context.put("currentPage", currentNote);
            }
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            path = URLDecoder.decode(path, "utf-8");
            context.put("path", path);
            WikiPageParams noteParam = TreeUtils.getPageParamsFromPath(path);
            Page note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
            if (note == null) {
                log.warn("User [{}] can not get noteBook path [{}]. Wiki Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), "WikiHome");
                if (note == null) {
                    ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.wiki.WikiPortlet", request.getLocale());
                    String errorMessage = "";
                    if (resourceBundle != null) {
                        errorMessage = resourceBundle.getString("UIWikiMovePageForm.msg.no-permission-at-wiki-destination");
                    }
                    return Response.serverError().entity((Object)("{ \"message\": \"" + errorMessage + "\"}")).cacheControl(this.cc).build();
                }
            }
            context.put("selectedPage", note);
            context.put("excerpt", showExcerpt);
            if (type.equalsIgnoreCase(TreeNode.TREETYPE.ALL.toString())) {
                Stack<WikiPageParams> stk = Utils.getStackParams(note);
                context.put("stackParams", stk);
                responseData = this.getJsonTree(noteParam, context);
            } else if (type.equalsIgnoreCase(TreeNode.TREETYPE.CHILDREN.toString())) {
                if (depth == null) {
                    depth = "1";
                }
                context.put("depth", depth);
                responseData = this.getJsonDescendants(noteParam, context);
            }
            this.encodeWikiTree(responseData, request.getLocale());
            return Response.ok(new BeanToJsons<JsonNodeData>(responseData), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{path, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error((Object)("Failed for get tree data by rest service - Cause : " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    private List<JsonNodeData> getJsonTree(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(params.getType(), params.getOwner());
        WikiTreeNode noteBookNode = new WikiTreeNode(noteBook);
        noteBookNode.pushDescendants(context);
        return TreeUtils.tranformToJson(noteBookNode, context);
    }

    private List<JsonNodeData> getJsonDescendants(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        TreeNode treeNode = TreeUtils.getDescendants(params, context);
        return TreeUtils.tranformToJson(treeNode, context);
    }

    private void encodeWikiTree(List<JsonNodeData> responseData, Locale locale) throws Exception {
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.wiki.service.WikiService", locale);
        String untitledLabel = "";
        if (resourceBundle == null) {
            log.warn("Cannot find resource bundle '{}'", new Object[]{"locale.wiki.service.WikiService"});
        } else {
            untitledLabel = resourceBundle.getString("Page.Untitled");
        }
        for (JsonNodeData data : responseData) {
            if (StringUtils.isBlank((String)data.getName())) {
                data.setName(untitledLabel);
            }
            if (!CollectionUtils.isNotEmpty(data.children)) continue;
            this.encodeWikiTree(data.children, locale);
        }
    }
}

