/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.HTMLSanitizer;

public class WikiHTMLSanitizer
extends HTMLSanitizer {
    public static String markupSanitize(String html) throws Exception {
        String htmlSanitized = "";
        if (html.contains("<!--")) {
            String[] splittedHTML = html.replaceAll("\n", "").split("(?=<!?--)");
            String[] commentSplitted = new String[splittedHTML.length];
            String[] contentSplitted = new String[splittedHTML.length];
            Pattern p = Pattern.compile("(<!--.*-->)(.*)");
            for (int i = 0; i < splittedHTML.length; ++i) {
                if (splittedHTML[i].startsWith("<!--")) {
                    Matcher matcher = p.matcher(splittedHTML[i]);
                    while (matcher.find()) {
                        commentSplitted[i] = matcher.group(1);
                        contentSplitted[i] = HTMLSanitizer.sanitize((String)matcher.group(2));
                    }
                } else {
                    contentSplitted[i] = splittedHTML[i];
                    commentSplitted[i] = "";
                }
                htmlSanitized = htmlSanitized.concat(commentSplitted[i]).concat(contentSplitted[i]);
            }
        } else {
            htmlSanitized = WikiHTMLSanitizer.sanitize((String)html);
        }
        return htmlSanitized;
    }
}

