/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.social.core.space.SpaceApplication;

public class SpaceTemplate
implements Cloneable {
    private String name;
    private String resolvedLabel;
    private String resolvedDescription;
    private String visibility;
    private String registration;
    private String bannerPath;
    private String permissions;
    private String permissionsLabels;
    private String invitees;
    private SpaceApplication homePageApplication;
    private List<SpaceApplication> applications;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setResolvedLabel(String resolvedLabel) {
        this.resolvedLabel = resolvedLabel;
    }

    public String getResolvedLabel() {
        return this.resolvedLabel;
    }

    public void setResolvedDescription(String resolvedDescription) {
        this.resolvedDescription = resolvedDescription;
    }

    public String getResolvedDescription() {
        return this.resolvedDescription;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setBannerPath(String bannerPath) {
        this.bannerPath = bannerPath;
    }

    public String getBannerPath() {
        return this.bannerPath;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissionsLabels(String permissionsLabels) {
        this.permissionsLabels = permissionsLabels;
    }

    public String getPermissionsLabels() {
        return this.permissionsLabels;
    }

    public void setInvitees(String invitees) {
        this.invitees = invitees;
    }

    public String getInvitees() {
        return this.invitees;
    }

    public void addToSpaceApplicationList(SpaceApplication spaceApplication) {
        if (this.applications == null) {
            this.applications = new ArrayList<SpaceApplication>();
        }
        this.applications.removeIf(o -> o.getPortletApp().equals(spaceApplication.getPortletApp()) && o.getPortletName().equals(spaceApplication.getPortletName()));
        this.applications.add(spaceApplication);
    }

    public void setSpaceApplicationList(List<SpaceApplication> applicationList) {
        this.applications = applicationList;
    }

    public List<SpaceApplication> getSpaceApplicationList() {
        return this.applications == null ? null : this.applications.stream().sorted(Comparator.comparing(SpaceApplication::getOrder)).collect(Collectors.toList());
    }

    public void setHomeApplication(SpaceApplication homeApplication) {
        this.homePageApplication = homeApplication;
    }

    public SpaceApplication getSpaceHomeApplication() {
        return this.homePageApplication;
    }

    public SpaceTemplate clone() {
        try {
            SpaceTemplate spaceTemplate = (SpaceTemplate)super.clone();
            spaceTemplate.homePageApplication = this.homePageApplication.clone();
            return spaceTemplate;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

