/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.List;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.JDBCNavigationServiceImpl;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class JDBCNavigationServiceWrapper
implements NavigationService {
    private static final Logger log = LoggerFactory.getLogger(JDBCNavigationServiceWrapper.class);
    private final JDBCNavigationServiceImpl service;
    private final ListenerService listenerService;

    public JDBCNavigationServiceWrapper(NavigationStore store, ListenerService listenerService) {
        this.service = new JDBCNavigationServiceImpl(store);
        this.listenerService = listenerService;
    }

    public NavigationContext loadNavigation(SiteKey key) {
        return this.service.loadNavigation(key);
    }

    public List<NavigationContext> loadNavigations(SiteType type) throws NullPointerException, NavigationServiceException {
        return this.service.loadNavigations(type);
    }

    public void saveNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        boolean created = this.service.loadNavigation(navigation.key) == null;
        this.service.saveNavigation(navigation);
        if (created) {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_created", navigation.getKey());
        } else {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_updated", navigation.getKey());
        }
    }

    public boolean destroyNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        this.notify("org.exoplatform.portal.mop.navigation.navigation_destroy", navigation.getKey());
        boolean destroyed = this.service.destroyNavigation(navigation);
        if (destroyed) {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_destroyed", navigation.key);
        }
        return destroyed;
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, NavigationContext navigation, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        return this.service.loadNode(model, navigation, scope, listener);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) throws NavigationServiceException {
        this.service.saveNode(context, new NodeChangeNotifier<N>(listener, this, this.listenerService));
    }

    public <N> void updateNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.service.updateNode(context, scope, listener);
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.service.rebaseNode(context, scope, listener);
    }

    private void notify(String name, SiteKey key) {
        try {
            this.listenerService.broadcast(name, (Object)this, (Object)key);
        }
        catch (Exception e) {
            log.error((Object)("Error when delivering notification " + name + " for navigation " + key), (Throwable)e);
        }
    }

    public static class NodeChangeNotifier<N>
    implements NodeChangeListener<NodeContext<N>> {
        private NodeChangeListener<NodeContext<N>> listener;
        private ListenerService listenerService;
        private NavigationService navigationService;

        public NodeChangeNotifier(NodeChangeListener<NodeContext<N>> listener, NavigationService navigationService, ListenerService listenerService) {
            this.listener = listener;
            this.listenerService = listenerService;
            this.navigationService = navigationService;
        }

        public void onAdd(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_add", target);
            if (this.listener != null) {
                this.listener.onAdd(target, parent, previous);
            }
        }

        public void onCreate(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous, String name) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_create", target);
            if (this.listener != null) {
                this.listener.onCreate(target, parent, previous, name);
            }
        }

        public void onRemove(NodeContext<N> target, NodeContext<N> parent) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_remove", target);
            if (this.listener != null) {
                this.listener.onRemove(target, parent);
            }
        }

        public void onDestroy(NodeContext<N> target, NodeContext<N> parent) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_destroy", target);
            if (this.listener != null) {
                this.listener.onDestroy(target, parent);
            }
        }

        public void onRename(NodeContext<N> target, NodeContext<N> parent, String name) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_rename", target);
            if (this.listener != null) {
                this.listener.onRename(target, parent, name);
            }
        }

        public void onUpdate(NodeContext<N> target, NodeState state) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_update", target);
            if (this.listener != null) {
                this.listener.onUpdate(target, state);
            }
        }

        public void onMove(NodeContext<N> target, NodeContext<N> from, NodeContext<N> to, NodeContext<N> previous) {
            this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_move", target);
            if (this.listener != null) {
                this.listener.onMove(target, from, to, previous);
            }
        }

        private void notifyNodeChange(String eventName, NodeContext<N> target) {
            try {
                log.debug((Object)("Broadcasting change type " + eventName + " notification for node " + target.getId() + " name " + target.getName()));
                this.listenerService.broadcast(eventName, (Object)this.navigationService, target);
            }
            catch (Exception e) {
                log.error((Object)("Error when delivering notification " + eventName + " for node " + target.getId()), (Throwable)e);
            }
        }
    }
}

