/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Releasability_Type", propOrder={"addressees", "statement", "disseminationConstraints"})
@XmlRootElement(name="MD_Releasability")
@UML(identifier="MD_Releasability", specification=Specification.ISO_19115)
public class DefaultReleasability
extends ISOMetadata {
    private static final long serialVersionUID = 4449531804328254887L;
    private Collection<DefaultResponsibility> addressees;
    private InternationalString statement;
    private Collection<Restriction> disseminationConstraints;

    public DefaultReleasability() {
    }

    public DefaultReleasability(DefaultReleasability defaultReleasability) {
        super(defaultReleasability);
        if (defaultReleasability != null) {
            this.addressees = this.copyCollection(defaultReleasability.getAddressees(), DefaultResponsibility.class);
            this.statement = defaultReleasability.getStatement();
            this.disseminationConstraints = this.copyCollection(defaultReleasability.getDisseminationConstraints(), Restriction.class);
        }
    }

    @XmlElement(name="addressee")
    @UML(identifier="addressee", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultResponsibility> getAddressees() {
        this.addressees = this.nonNullCollection(this.addressees, DefaultResponsibility.class);
        return this.addressees;
    }

    public void getAddressees(Collection<? extends DefaultResponsibility> collection) {
        this.addressees = this.writeCollection(collection, this.addressees, DefaultResponsibility.class);
    }

    @XmlElement(name="statement")
    @UML(identifier="statement", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString internationalString) {
        this.checkWritePermission(this.statement);
        this.statement = internationalString;
    }

    @XmlElement(name="disseminationConstraints")
    @UML(identifier="disseminationConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Restriction> getDisseminationConstraints() {
        this.disseminationConstraints = this.nonNullCollection(this.disseminationConstraints, Restriction.class);
        return this.disseminationConstraints;
    }

    public void getDisseminationConstraints(Collection<? extends Restriction> collection) {
        this.disseminationConstraints = this.writeCollection(collection, this.disseminationConstraints, Restriction.class);
    }
}

