/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.search.domain.OperationType;

@Entity
@ExoEntity
@Table(name="ES_INDEXING_QUEUE")
@NamedQueries(value={@NamedQuery(name="IndexingOperation.deleteAllIndexingOperationsHavingIdLessThanOrEqual", query="DELETE FROM IndexingOperation q WHERE q.id <= :id"), @NamedQuery(name="IndexingOperation.deleteAllByEntityIndex", query="DELETE FROM IndexingOperation q WHERE q.entityIndex = :entityIndex"), @NamedQuery(name="IndexingOperation.findAll", query="SELECT q FROM IndexingOperation q ORDER BY q.id")})
public class IndexingOperation
implements Serializable {
    private static final long serialVersionUID = -2647286678124583999L;
    @Id
    @SequenceGenerator(name="SEQ_ES_INDEXING_QUEUE_ID", sequenceName="SEQ_ES_INDEXING_QUEUE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_ES_INDEXING_QUEUE_ID")
    @Column(name="OPERATION_ID")
    private Long id;
    @Column(name="ENTITY_TYPE")
    private String entityIndex;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="OPERATION_TYPE")
    private String operation;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="OPERATION_TIMESTAMP", insertable=false, updatable=false)
    private Date timestamp;

    public IndexingOperation() {
    }

    public IndexingOperation(String entityId, String entityIndex, OperationType operation) {
        this.entityId = entityId;
        this.entityIndex = entityIndex;
        this.setOperation(operation);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityIndex() {
        return this.entityIndex;
    }

    public void setEntityIndex(String entityIndex) {
        this.entityIndex = entityIndex;
    }

    public OperationType getOperation() {
        return this.operation == null ? null : OperationType.getById(this.operation);
    }

    public void setOperation(OperationType operation) {
        this.operation = operation == null ? null : operation.getOperationId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexingOperation that = (IndexingOperation)o;
        if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) {
            return false;
        }
        if (this.entityIndex != null ? !this.entityIndex.equals(that.entityIndex) : that.entityIndex != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.operation != null ? !this.operation.equals(that.operation) : that.operation != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.entityIndex != null ? this.entityIndex.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        return result;
    }
}

