/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.stemmer.snowball;

import opennlp.tools.stemmer.Stemmer;
import opennlp.tools.stemmer.snowball.AbstractSnowballStemmer;
import opennlp.tools.stemmer.snowball.arabicStemmer;
import opennlp.tools.stemmer.snowball.catalanStemmer;
import opennlp.tools.stemmer.snowball.danishStemmer;
import opennlp.tools.stemmer.snowball.dutchStemmer;
import opennlp.tools.stemmer.snowball.englishStemmer;
import opennlp.tools.stemmer.snowball.finnishStemmer;
import opennlp.tools.stemmer.snowball.frenchStemmer;
import opennlp.tools.stemmer.snowball.germanStemmer;
import opennlp.tools.stemmer.snowball.greekStemmer;
import opennlp.tools.stemmer.snowball.hungarianStemmer;
import opennlp.tools.stemmer.snowball.indonesianStemmer;
import opennlp.tools.stemmer.snowball.irishStemmer;
import opennlp.tools.stemmer.snowball.italianStemmer;
import opennlp.tools.stemmer.snowball.norwegianStemmer;
import opennlp.tools.stemmer.snowball.porterStemmer;
import opennlp.tools.stemmer.snowball.portugueseStemmer;
import opennlp.tools.stemmer.snowball.romanianStemmer;
import opennlp.tools.stemmer.snowball.russianStemmer;
import opennlp.tools.stemmer.snowball.spanishStemmer;
import opennlp.tools.stemmer.snowball.swedishStemmer;
import opennlp.tools.stemmer.snowball.turkishStemmer;

public class SnowballStemmer
implements Stemmer {
    private final AbstractSnowballStemmer stemmer;
    private final int repeat;

    public SnowballStemmer(ALGORITHM algorithm, int repeat) {
        this.repeat = repeat;
        if (ALGORITHM.ARABIC.equals((Object)algorithm)) {
            this.stemmer = new arabicStemmer();
        } else if (ALGORITHM.DANISH.equals((Object)algorithm)) {
            this.stemmer = new danishStemmer();
        } else if (ALGORITHM.DUTCH.equals((Object)algorithm)) {
            this.stemmer = new dutchStemmer();
        } else if (ALGORITHM.CATALAN.equals((Object)algorithm)) {
            this.stemmer = new catalanStemmer();
        } else if (ALGORITHM.ENGLISH.equals((Object)algorithm)) {
            this.stemmer = new englishStemmer();
        } else if (ALGORITHM.FINNISH.equals((Object)algorithm)) {
            this.stemmer = new finnishStemmer();
        } else if (ALGORITHM.FRENCH.equals((Object)algorithm)) {
            this.stemmer = new frenchStemmer();
        } else if (ALGORITHM.GERMAN.equals((Object)algorithm)) {
            this.stemmer = new germanStemmer();
        } else if (ALGORITHM.GREEK.equals((Object)algorithm)) {
            this.stemmer = new greekStemmer();
        } else if (ALGORITHM.HUNGARIAN.equals((Object)algorithm)) {
            this.stemmer = new hungarianStemmer();
        } else if (ALGORITHM.INDONESIAN.equals((Object)algorithm)) {
            this.stemmer = new indonesianStemmer();
        } else if (ALGORITHM.IRISH.equals((Object)algorithm)) {
            this.stemmer = new irishStemmer();
        } else if (ALGORITHM.ITALIAN.equals((Object)algorithm)) {
            this.stemmer = new italianStemmer();
        } else if (ALGORITHM.NORWEGIAN.equals((Object)algorithm)) {
            this.stemmer = new norwegianStemmer();
        } else if (ALGORITHM.PORTER.equals((Object)algorithm)) {
            this.stemmer = new porterStemmer();
        } else if (ALGORITHM.PORTUGUESE.equals((Object)algorithm)) {
            this.stemmer = new portugueseStemmer();
        } else if (ALGORITHM.ROMANIAN.equals((Object)algorithm)) {
            this.stemmer = new romanianStemmer();
        } else if (ALGORITHM.RUSSIAN.equals((Object)algorithm)) {
            this.stemmer = new russianStemmer();
        } else if (ALGORITHM.SPANISH.equals((Object)algorithm)) {
            this.stemmer = new spanishStemmer();
        } else if (ALGORITHM.SWEDISH.equals((Object)algorithm)) {
            this.stemmer = new swedishStemmer();
        } else if (ALGORITHM.TURKISH.equals((Object)algorithm)) {
            this.stemmer = new turkishStemmer();
        } else {
            throw new IllegalStateException("Unexpected stemmer algorithm: " + algorithm.toString());
        }
    }

    public SnowballStemmer(ALGORITHM algorithm) {
        this(algorithm, 1);
    }

    @Override
    public CharSequence stem(CharSequence word) {
        this.stemmer.setCurrent(word.toString());
        for (int i = 0; i < this.repeat; ++i) {
            this.stemmer.stem();
        }
        return this.stemmer.getCurrent();
    }

    public static enum ALGORITHM {
        ARABIC,
        DANISH,
        DUTCH,
        CATALAN,
        ENGLISH,
        FINNISH,
        FRENCH,
        GERMAN,
        GREEK,
        HUNGARIAN,
        INDONESIAN,
        IRISH,
        ITALIAN,
        NORWEGIAN,
        PORTER,
        PORTUGUESE,
        ROMANIAN,
        RUSSIAN,
        SPANISH,
        SWEDISH,
        TURKISH;

    }
}

