/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.util.logging.Logging;

public final class AxisNames {
    public static final String LONGITUDE = "Longitude";
    public static final String LATITUDE = "Latitude";
    public static final String GEODETIC_LONGITUDE = "Geodetic longitude";
    public static final String GEODETIC_LATITUDE = "Geodetic latitude";
    public static final String SPHERICAL_LONGITUDE = "Spherical longitude";
    public static final String SPHERICAL_LATITUDE = "Spherical latitude";
    public static final String ELLIPSOIDAL_HEIGHT = "Ellipsoidal height";
    public static final String GRAVITY_RELATED_HEIGHT = "Gravity-related height";
    public static final String DEPTH = "Depth";
    public static final String GEOCENTRIC_X = "Geocentric X";
    public static final String GEOCENTRIC_Y = "Geocentric Y";
    public static final String GEOCENTRIC_Z = "Geocentric Z";
    public static final String GEOCENTRIC_RADIUS = "Geocentric radius";
    public static final String EASTING = "Easting";
    public static final String WESTING = "Westing";
    public static final String NORTHING = "Northing";
    public static final String SOUTHING = "Southing";
    public static final String TIME = "Time";
    private static final Map<String, String> VALUES;

    private AxisNames() {
    }

    private static String toUpperCase(String string, StringBuilder stringBuilder) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            stringBuilder.append(Character.toUpperCase(c));
        }
        return stringBuilder.toString();
    }

    public static String toCamelCase(String string) {
        return VALUES.getOrDefault(AxisNames.toUpperCase(string, new StringBuilder(string.length())), string);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(22);
        StringBuilder stringBuilder = new StringBuilder(22);
        try {
            for (Field field : AxisNames.class.getFields()) {
                String string = (String)field.get(null);
                hashMap.put(AxisNames.toUpperCase(string, stringBuilder).intern(), string);
                stringBuilder.setLength(0);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing"), AxisNames.class, (String)"<cinit>", (Throwable)illegalAccessException);
        }
        VALUES = hashMap;
    }
}

