/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.tomcat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Engine;
import org.apache.catalina.Wrapper;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.tomcat.TomcatServletContainerContext;

public class TomcatContainerServlet
extends HttpServlet
implements ContainerServlet {
    private static final Logger log = LoggerFactory.getLogger(TomcatContainerServlet.class);
    private static final String CROSS_CONTEXT_LOGOUT_KEY = "org.gatein.wci.cross_context_logout";
    private Wrapper wrapper;
    private TomcatServletContainerContext containerContext;
    private boolean started;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper != null) {
            this.attemptStart();
        } else {
            this.attemptStop();
        }
    }

    public void init() throws ServletException {
        this.started = true;
        this.attemptStart();
    }

    public void destroy() {
        this.started = false;
        this.attemptStop();
    }

    private void attemptStart() {
        if (this.started && this.wrapper != null) {
            this.start();
        }
    }

    private void attemptStop() {
        if (!this.started || this.wrapper == null) {
            this.stop();
        }
    }

    private void start() {
        Wrapper container = this.wrapper;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof Engine)) continue;
            Engine engine = (Engine)container;
            this.containerContext = new TomcatServletContainerContext(engine);
            this.containerContext.setCrossContextLogout(this.getCrossContextLogoutConfig());
            this.containerContext.start();
            break;
        }
    }

    private void stop() {
        if (this.containerContext != null) {
            this.containerContext.stop();
            this.containerContext = null;
        }
    }

    private boolean getCrossContextLogoutConfig() {
        String val = this.getServletContext().getInitParameter(CROSS_CONTEXT_LOGOUT_KEY);
        if (val == null || Boolean.valueOf(val).booleanValue()) {
            return true;
        }
        if (!"false".equalsIgnoreCase(val)) {
            log.warn((Object)("Context init param org.gatein.wci.cross_context_logout value is invalid: " + val + " - falling back to: false"));
        }
        log.info((Object)"Cross-context session invalidation on logout disabled");
        return false;
    }
}

