/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.pc.ExoResourceBundleFactory;
import org.exoplatform.portal.pc.GlobalPortletMetaData;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployment;
import org.gatein.pc.portlet.impl.deployment.staxnav.PortletApplicationMetaDataBuilder;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;

public class ExoPortletApplicationDeployer
extends PortletApplicationDeployer {
    private final Logger log = LoggerFactory.getLogger(ExoPortletApplicationDeployer.class);
    private ManagedObjectRegistryEventListener cdiListener;

    public ExoPortletApplicationDeployer() {
        this(null);
    }

    public ExoPortletApplicationDeployer(ContainerPortletInvoker containerPortletInvoker) {
        super(containerPortletInvoker);
        try {
            Class<?> clazz = Class.forName("org.gatein.cdi.CDIInjectionListener");
            Object listenerInstance = clazz.newInstance();
            if (listenerInstance instanceof ManagedObjectRegistryEventListener) {
                this.cdiListener = (ManagedObjectRegistryEventListener)listenerInstance;
                if (null != this.cdiListener) {
                    this.addListener(this.cdiListener);
                }
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to create org.gatein.cdiCDIInjectionListener", (Throwable)e);
        }
    }

    protected PortletApplication10MetaData buildPortletApplicationMetaData(ServletContext webApp) throws DeploymentException {
        PortletApplication10MetaData md;
        block7: {
            md = super.buildPortletApplicationMetaData(webApp);
            if (md != null) {
                md.setResourceBundleFactoryName(ExoResourceBundleFactory.class.getName());
                String globalPortletLocation = PropertyManager.getProperty((String)"gatein.portlet.config");
                if (globalPortletLocation != null) {
                    try {
                        GlobalPortletMetaData globalPortletMetaData = this.loadGlobalMetadata(globalPortletLocation);
                        if (globalPortletMetaData != null) {
                            globalPortletMetaData.mergeTo(md);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Complete merging global portlet metadata to portlet application " + webApp.getServletContextName()));
                        }
                        break block7;
                    }
                    catch (Exception ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Error during merge global portlet metadata to portlet application " + webApp.getServletContextName()), (Throwable)ex);
                        }
                        break block7;
                    }
                }
                this.log.warn((Object)"The global portlet metadata is not configured");
            }
        }
        return md;
    }

    protected PortletApplicationDeployment createPortletApplicationDeployment(ServletContext webApp, PortletApplication10MetaData metaData) {
        return super.createPortletApplicationDeployment(webApp, metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalPortletMetaData loadGlobalMetadata(String globalPortletLocation) throws Exception {
        File globalPortletFile = new File(globalPortletLocation);
        if (globalPortletFile.exists()) {
            FileInputStream in = new FileInputStream(globalPortletFile);
            try {
                PortletApplicationMetaDataBuilder builder = new PortletApplicationMetaDataBuilder();
                GlobalPortletMetaData globalPortletMetaData = GlobalPortletMetaData.unmarshalling(in);
                return globalPortletMetaData;
            }
            finally {
                Safe.close((Closeable)in);
            }
        }
        return null;
    }
}

