/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile.settings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.IMTypesPlugin;

public class UserProfileSettingsService {
    private static final Log LOG = ExoLogger.getLogger(UserProfileSettingsService.class);
    protected final Map<String, IMType> imTypesMap = new HashMap<String, IMType>();

    public void addIMType(IMType imType) {
        IMType prev = this.imTypesMap.put(imType.getId(), imType);
        if (prev != null) {
            LOG.info((Object)("IM type '" + imType.getId() + "' redefined from '" + prev + "' to '" + imType + "'"));
        }
    }

    public void addIMTypesPlugin(IMTypesPlugin plugin) {
        for (IMType imt : plugin.getTypes()) {
            this.addIMType(imt);
        }
    }

    public Collection<IMType> getIMTypes() {
        return Collections.unmodifiableCollection(this.imTypesMap.values());
    }

    public IMType getIMType(String id) {
        return this.imTypesMap.get(id);
    }
}

