/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import org.apache.sis.util.logging.Logging;

public enum OS {
    UNKNOWN,
    WINDOWS,
    MAC_OS,
    LINUX;


    public static String uname() {
        try {
            return System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), OS.class, "uname", securityException);
            return null;
        }
    }

    public static OS current() {
        String string = OS.uname();
        if (string != null) {
            if (string.contains("Windows")) {
                return WINDOWS;
            }
            if (string.contains("Mac OS")) {
                return MAC_OS;
            }
            if (string.contains("Linux")) {
                return LINUX;
            }
        }
        return UNKNOWN;
    }
}

