/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.logging;

import java.lang.reflect.Method;
import org.gatein.common.logging.LogLevel;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public abstract class Logger {
    public static final int SLF_1_5 = 0;
    public static final int SLF_1_6 = 1;
    static Method log;
    public static final int LOGGER;
    private static final Object[] NO_PARAMETERS;

    private static Method getLogMethod(Class ... signature) {
        try {
            return LocationAwareLogger.class.getMethod("log", signature);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    protected abstract void doLog(LogLevel var1, Object var2, Object[] var3, Throwable var4);

    protected abstract org.slf4j.Logger getDelegate();

    private void log(LogLevel level, Object msg, Throwable throwable, Object ... parameters) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        if (parameters != null && parameters.length > 0) {
            throw new UnsupportedOperationException("log interpolation to do, for now it cannot be called");
        }
        this.doLog(level, msg, parameters, throwable);
    }

    public final String getName() {
        return this.getDelegate().getName();
    }

    public final boolean isEnabled(LogLevel level) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        return level.isEnabled(this.getDelegate());
    }

    public final void log(LogLevel level, Object msg) {
        this.log(level, msg, null, NO_PARAMETERS);
    }

    public final void log(LogLevel level, Object msg, Throwable throwable) {
        this.log(level, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isTraceEnabled() {
        return this.isEnabled(LogLevel.TRACE);
    }

    public final void trace(Object msg) {
        this.log(LogLevel.TRACE, msg, null, NO_PARAMETERS);
    }

    public final void trace(Object msg, Throwable throwable) {
        this.log(LogLevel.TRACE, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isDebugEnabled() {
        return this.isEnabled(LogLevel.DEBUG);
    }

    public final void debug(Object msg) {
        this.log(LogLevel.DEBUG, msg, null, NO_PARAMETERS);
    }

    public final void debug(Object msg, Throwable throwable) {
        this.log(LogLevel.DEBUG, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabled(LogLevel.INFO);
    }

    public final void info(Object msg) {
        this.log(LogLevel.INFO, msg, null, NO_PARAMETERS);
    }

    public final void info(Object msg, Throwable throwable) {
        this.log(LogLevel.INFO, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isWarnEnabled() {
        return this.isEnabled(LogLevel.WARN);
    }

    public final void warn(Object msg) {
        this.log(LogLevel.WARN, msg, null, NO_PARAMETERS);
    }

    public final void warn(Object msg, Throwable throwable) {
        this.log(LogLevel.WARN, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isErrorEnabled() {
        return this.isEnabled(LogLevel.ERROR);
    }

    public final void error(Object msg) {
        this.log(LogLevel.ERROR, msg, null, NO_PARAMETERS);
    }

    public final void error(Object msg, Throwable throwable) {
        this.log(LogLevel.ERROR, msg, throwable, NO_PARAMETERS);
    }

    public String toString() {
        return "Logger[name=" + this.getDelegate().getName() + "]";
    }

    static {
        Method m = Logger.getLogMethod(Marker.class, String.class, Integer.TYPE, String.class, Throwable.class);
        if (m != null) {
            LOGGER = 0;
        } else {
            m = Logger.getLogMethod(Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
            if (m != null) {
                LOGGER = 1;
            } else {
                throw new AssertionError((Object)("Could not use with the found SLF 4J version " + LocationAwareLogger.class.getProtectionDomain().getCodeSource().getLocation()));
            }
        }
        log = m;
        NO_PARAMETERS = null;
    }
}

