/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.iso.DefaultInternationalString;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public class DefaultNameFactory
extends AbstractFactory
implements NameFactory {
    static final String SEPARATOR_KEY = "separator";
    static final String HEAD_SEPARATOR_KEY = "separator.head";
    private final WeakHashSet<GenericName> pool = new WeakHashSet(GenericName.class);
    private volatile transient TypeNames typeNames;

    public InternationalString createInternationalString(Map<Locale, String> map) {
        ArgumentChecks.ensureNonNull((String)"strings", map);
        switch (map.size()) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)30));
            }
            case 1: {
                return new SimpleInternationalString(map.values().iterator().next());
            }
        }
        return new DefaultInternationalString(map);
    }

    private static String getString(Map<String, ?> map, String string) {
        Object obj;
        if (map != null && (obj = map.get(string)) != null) {
            return obj.toString();
        }
        return null;
    }

    public NameSpace createNameSpace(GenericName genericName, Map<String, ?> map) {
        boolean bl;
        String string;
        ArgumentChecks.ensureNonNull((String)"name", (Object)genericName);
        String string2 = DefaultNameFactory.getString(map, SEPARATOR_KEY);
        if (string2 == null) {
            string2 = ":";
        }
        if ((string = DefaultNameFactory.getString(map, HEAD_SEPARATOR_KEY)) == null) {
            string = string2;
        }
        if ((bl = string2.isEmpty()) || string.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)32, (Object)(bl ? SEPARATOR_KEY : HEAD_SEPARATOR_KEY)));
        }
        return DefaultNameSpace.forName(genericName.toFullyQualifiedName(), string, string2);
    }

    public TypeName createTypeName(NameSpace nameSpace, CharSequence charSequence) {
        return (TypeName)this.pool.unique((Object)new DefaultTypeName(nameSpace, charSequence));
    }

    public MemberName createMemberName(NameSpace nameSpace, CharSequence charSequence, TypeName typeName) {
        return (MemberName)this.pool.unique((Object)new DefaultMemberName(nameSpace, charSequence, typeName));
    }

    public LocalName createLocalName(NameSpace nameSpace, CharSequence charSequence) {
        if (nameSpace instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).local(charSequence, null);
        }
        return (LocalName)this.pool.unique((Object)new DefaultLocalName(nameSpace, charSequence));
    }

    public GenericName createGenericName(NameSpace nameSpace, CharSequence ... charSequenceArray) {
        ArgumentChecks.ensureNonNull((String)"parsedNames", (Object)charSequenceArray);
        switch (charSequenceArray.length) {
            default: {
                return (GenericName)this.pool.unique((Object)new DefaultScopedName(nameSpace, Arrays.asList(charSequenceArray)));
            }
            case 1: {
                return this.createLocalName(nameSpace, charSequenceArray[0]);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format((short)29, (Object)"parsedNames"));
    }

    public GenericName parseGenericName(NameSpace nameSpace, CharSequence charSequence) {
        int n;
        String string = nameSpace instanceof DefaultNameSpace ? ((DefaultNameSpace)nameSpace).separator : ":";
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        String string2 = charSequence.toString();
        while ((n = string2.indexOf(string, n3)) >= 0) {
            arrayList.add(string2.substring(n3, n));
            n3 = n + n2;
        }
        arrayList.add(string2.substring(n3));
        if (arrayList.size() == 1) {
            return this.createLocalName(nameSpace, charSequence);
        }
        return this.createGenericName(nameSpace, arrayList.toArray(new String[arrayList.size()]));
    }

    public GenericName[] toGenericNames(Object object) throws ClassCastException {
        Object[] objectArray;
        if (object == null) {
            return null;
        }
        GenericName genericName = this.toGenericName(object);
        if (genericName != null) {
            return new GenericName[]{genericName};
        }
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            if (objectArray instanceof GenericName[]) {
                return (GenericName[])objectArray;
            }
        } else if (object instanceof Collection) {
            objectArray = ((Collection)object).toArray();
        } else {
            throw new ClassCastException(Errors.format((short)42, (Object)"value", object.getClass()));
        }
        GenericName[] genericNameArray = new GenericName[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            if (object == null) continue;
            genericName = this.toGenericName(object);
            if (genericName == null) {
                throw new ClassCastException(Errors.format((short)42, (Object)Strings.toIndexed((String)"value", (int)i), object.getClass()));
            }
            genericNameArray[i] = genericName;
        }
        return genericNameArray;
    }

    private GenericName toGenericName(Object object) {
        if (object instanceof GenericName) {
            return (GenericName)object;
        }
        if (object instanceof Identifier) {
            return this.parseGenericName(null, ((Identifier)object).getCode());
        }
        if (object instanceof CharSequence) {
            return this.parseGenericName(null, (CharSequence)object);
        }
        if (object instanceof Class) {
            return this.toTypeName((Class)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeName toTypeName(Class<?> clazz) {
        if (!TypeNames.isValid(clazz)) {
            return null;
        }
        TypeNames typeNames = this.typeNames;
        if (typeNames == null) {
            TypeNames typeNames2 = new TypeNames(this);
            DefaultNameFactory defaultNameFactory = this;
            synchronized (defaultNameFactory) {
                typeNames = this.typeNames;
                if (typeNames == null) {
                    this.typeNames = typeNames = typeNames2;
                }
            }
        }
        return typeNames.toTypeName(this, clazz);
    }
}

