/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

abstract class Pair<T, U> {
    private final T o1;
    private final U o2;
    private final int hashCode;

    Pair(T o1, U o2) {
        this.o1 = o1;
        this.o2 = o2;
        this.hashCode = this.doHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return !this.differentHashCode(other) && this.safeEquals(this.o1, other.o1) && this.safeEquals(this.o2, other.o2);
    }

    private boolean differentHashCode(Pair other) {
        return this.hashCode != other.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int doHashCode() {
        return this.safeHashCode(this.o1) ^ this.safeHashCode(this.o2);
    }

    private int safeHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    private boolean safeEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

